# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

bl_info = {
    "name" : "RigiCar",
    "author" : "Picto Filmo", 
    "description" : "",
    "blender" : (3, 3, 0),
    "version" : (2, 1, 3),
    "location" : "",
    "warning" : "",
    "doc_url": "", 
    "tracker_url": "", 
    "category" : "Rigging" 
}


import bpy
import bpy.utils.previews
import os
import webbrowser
from mathutils import Euler, Matrix, Vector
from bpy.app.handlers import persistent
from mathutils import *
import numpy
from math import sqrt
import blf
import random
import bl_math
from numpy import dot
from mathutils import Vector,Matrix,Euler
import copy


addon_keymaps = {}
_icons = None
carrig_setup = {'sna_name_tmp': '', 'sna_obj_tmp': None, 'sna_object_tmp': None, 'sna_rig_name_tmp': '', 'sna_curve_name_tmp': '', 'sna_collection_name_tmp': '', 'sna_cr_bool_tmp': False, 'sna_cr_param_buffer': [], 'sna_rendering_state': False, }


def sna_update_sna_cr_wheel_avg_CB0F2(self, context):
    sna_updated_prop = self.sna_cr_wheel_avg
    if bpy.context.view_layer.objects.active.sna_cr_wheel_avg:
        bpy.ops.sna.cr_op_setup_wheels_24503('INVOKE_DEFAULT', )
        areas = bpy.context.workspace.screens[0].areas
        for area in areas:
            for space in area.spaces:
                if space.type == 'VIEW_3D':
                    space.show_gizmo_object_translate = True
                    space.show_gizmo = True
                    bpy.ops.wm.tool_set_by_id(name="builtin.move")
                    bpy.context.scene.transform_orientation_slots[0].type = 'LOCAL'
                    #space.region_3d.view_camera_zoom -= 20
        ########################################################
        #region_3d.view_camera_zoom += foo
        #bpy.data.scenes['Scene'].transform_orientation_slots[0].type
        #bpy.ops.view3d.view_selected(use_all_regions=False)
        #######################################################
        #v3d = [x for x in bpy.context.screen.areas if x.type == 'VIEW_3D']
        #if v3d:
        #    # you need to decide what to do if there are more than one 3D Views present
        #    # you could either set the orientation on the first one, or on a specific one
        #    # to set it on all views:
        #    for v in v3d:
        #        v.spaces[0].transform_orientation = 'LOCAL'
        if (not carrig_setup['sna_cr_bool_tmp']):
            bpy.ops.sna.cr_mop_algin_wheels_f10c6('INVOKE_DEFAULT', sna_pos_x=0, sna_pos_y=0)
    else:
        car = bpy.context.object
        bpy.ops.object.select_all(action='DESELECT')
        #### clear carrig 
        car_id = car.sna_cr_id_collec
        try:
            wheel_mat = car.sna_cr_wheel_avg.matrix_world
            car.sna_cr_wheel_avg.parent = None
            car.sna_cr_wheel_avg.matrix_world = wheel_mat
            car.sna_cr_wheel_avg.scale = (1.0,1.0,1.0)
            car.sna_cr_wheel_scale = 1.0
        except:
            print('no wheel')
        try:
            car_id[0].wheel_avd.hide_select = False
            car_id[0].wheel_avd.select_set(True)
            car_id[0].wheel_ard.hide_select = False
            car_id[0].wheel_ard.select_set(True)
            car_id[0].wheel_arg.hide_select = False
            car_id[0].wheel_arg.select_set(True)
        except:
            print('no wheel')
        bpy.ops.object.delete()
        car.select_set(True)
        bpy.context.view_layer.objects.active = car


def sna_update_sna_cr_view_rig_3E926(self, context):
    sna_updated_prop = self.sna_cr_view_rig
    carrig = list(self.sna_cr_id_collec)[0].rig
    bool = sna_updated_prop
    carrig.data.layers[15] = True
    carrig.data.layers[23] = bool


def sna_update_sna_cr_carrig_curve_B7497(self, context):
    sna_updated_prop = self.sna_cr_carrig_curve
    carrig = list(self.sna_cr_id_collec)[0].rig
    curve = sna_updated_prop
    car = self
    bones = carrig.pose.bones
    bone_name = ['main_drive','steering','main_target']#,'ARG','ARD','AVG','AVD']
    if car.sna_cr_carrig_curve:
        for name in bone_name:
            bones[name].constraints['Follow Path'].target = curve
    else:
        for name in bone_name:
            bones[name].constraints['Follow Path'].target = None
    car = self
    bpy.context.view_layer.update()
    path = car.sna_cr_carrig_curve
    curve_len = path.data.splines[0].calc_length()
    carrig = car.sna_cr_id_collec[0].rig
    carrig["CarRig_path_len"] = path.data.splines[0].calc_length()
    main_offset = carrig.pose.bones['main_drive'].constraints["Follow Path"].offset_factor
    scale = carrig.pose.bones['main_drive_scale'].scale.x
    ##### .1*45.50459289550781*0.4395 = 1.9999268577575686 donc 2 !
    steer_offset = main_offset+scale*2/curve_len
    carrig.pose.bones['steering'].constraints["Follow Path"].offset_factor = steer_offset
    bpy.context.view_layer.update()
    carrig.pose.bones['main_target'].constraints["Follow Path"].offset_factor = main_offset*.35 + steer_offset*.65
    bpy.context.view_layer.update()


def sna_update_sna_cr_wheel_scale_3F964(self, context):
    sna_updated_prop = self.sna_cr_wheel_scale
    carrig = list(self.sna_cr_id_collec)[0].rig
    s = sna_updated_prop
    car = self
    carrig_bones = carrig.pose.bones
    wheel = car.sna_cr_wheel_avg
    bpy.context.view_layer.update() 
    ### calcul rayon roue:
    dim = wheel.dimensions.x
    if wheel.dimensions.y > dim:
        dim = wheel.dimensions.y
    if wheel.dimensions.z > dim:
        dim = wheel.dimensions.z            
    car.sna_cr_wheel_radius = dim / 2
    carrig_bones['AVG.steer.W'].scale = (s,s,s)
    carrig_bones['AVD.steer.W'].scale = (s,s,s)
    carrig_bones['ARD.W'].scale = (s,s,s)
    carrig_bones['ARG.W'].scale = (s,s,s)
    carrig_bones['AVG.steer.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
    carrig_bones['AVD.steer.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
    carrig_bones['ARD.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
    carrig_bones['ARG.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)


def sna_update_sna_cr_chassis_long_AAFA8(self, context):
    sna_updated_prop = self.sna_cr_chassis_long
    long = sna_updated_prop
    car = self
    large = self.sna_cr_chassis_large
    car_id = car.sna_cr_id_collec
    carrig = car_id[0].rig
    carrig.pose.bones['main_drive_scale'].scale = (large,1.0,long)
    carrig.pose.bones['body_scale'].scale = (large,1.0,long)
    carrig["CarRig_Drift_distance"] = 2*large


def sna_update_sna_cr_sb_global_spring_66507(self, context):
    sna_updated_prop = self.sna_cr_sb_global_spring
    carrig = list(self.sna_cr_id_collec)[0].rig
    enable = sna_updated_prop
    if enable:
        carrig.pose.bones['ARG_sp_to_track_to'].constraints['snap'].enabled = False
        carrig.pose.bones['AVG.steer_sp_to_track_to'].constraints['snap'].enabled = False
        carrig.pose.bones['AVD.steer_sp_to_track_to'].constraints['snap'].enabled = False
        carrig.pose.bones['ARD_sp_to_track_to'].constraints['snap'].enabled = False
    else:
        carrig.pose.bones['ARG_sp_to_track_to'].constraints['snap'].enabled = True
        carrig.pose.bones['AVG.steer_sp_to_track_to'].constraints['snap'].enabled = True
        carrig.pose.bones['AVD.steer_sp_to_track_to'].constraints['snap'].enabled = True
        carrig.pose.bones['ARD_sp_to_track_to'].constraints['snap'].enabled = True


def sna_get_outliner_collection_C555D_7A449(object):
    object = object
    collection_name = None
    collection_name = object.users_collection[0].name
    return collection_name


def sna_move_outliner_collection_object_A90B9_17144(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_EC909(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_3369A(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_086DB(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_E1FB8(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_A4559(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_update_sna_cr_chassis_large_F70FE(self, context):
    sna_updated_prop = self.sna_cr_chassis_large
    large = sna_updated_prop
    car = self
    long = self.sna_cr_chassis_long
    car_id = car.sna_cr_id_collec
    carrig = car_id[0].rig
    carrig.pose.bones['main_drive_scale'].scale = (large,1.0,long)
    carrig.pose.bones['body_scale'].scale = (large,1.0,long)
    carrig["CarRig_Drift_distance"] = 2*large


def sna_update_sna_cr_ground_obj_8D338(self, context):
    sna_updated_prop = self.sna_cr_ground_obj
    carrig = list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig
    ground = sna_updated_prop
    car = self
    tmp_slect = bpy.context.object
    bones = carrig.pose.bones
    bone_name = ['ARG','ARD','AVG','AVD','ground_normale','ground_normale.AVD','ground_normale.AVG','ground_normale.ARD','ground_normale.ARG']
    if car.sna_cr_ground_obj:
        bpy.ops.object.select_all(action='DESELECT')
        car.sna_cr_ground_obj.select_set(True)
        bpy.context.view_layer.objects.active = car.sna_cr_ground_obj
        bpy.ops.object.shade_smooth()
        bpy.ops.object.select_all(action='DESELECT')
        tmp_slect.select_set(True)
        bpy.context.view_layer.objects.active = tmp_slect
        for name in bone_name:
            bones[name].constraints['Shrinkwrap'].target = ground
    else:
        for name in bone_name:
            bones[name].constraints['Shrinkwrap'].target = None


def property_exists(prop_path, glob, loc):
    try:
        eval(prop_path, glob, loc)
        return True
    except:
        return False


def sna_update_sna_cr_path_distance_FDA27(self, context):
    sna_updated_prop = self.sna_cr_path_distance
    distance = sna_updated_prop
    path_curve = self.sna_cr_carrig_curve
    car = self
    speed = None
    offset_factor = None
    #import bl_math
    #from math import sqrt, degrees, dist
    #from mathutils import *
    #import numpy
    #from numpy import dot

    def has_keyframe(ob, attr):
        anim = ob.animation_data
        if anim is not None and anim.action is not None:
            for fcu in anim.action.fcurves:
                if fcu.data_path == attr:
                    return len(fcu.keyframe_points) > 0
        return False
    bpy.context.view_layer.update()
    curve_len = path_curve.data.splines[0].calc_length()
    f =  distance / curve_len
    acceleration = 0.0
    if f <= 1.0:
        offset_factor = f
    else:
        offset_factor = 1.0
        car.sna_cr_path_distance = curve_len
    if has_keyframe(car, 'sna_cr_path_distance'):
        frame = bpy.context.scene.frame_current
        bpy.context.view_layer.update()
        if frame > bpy.context.scene.frame_start:       
            f = car.animation_data.action.fcurves.find('sna_cr_path_distance')
            speed = (car.sna_cr_path_distance - f.evaluate(frame-1)) * bpy.context.scene.render.fps * 3.6
            if frame > bpy.context.scene.frame_start+1:
                speed_before = (f.evaluate(frame - 1) - f.evaluate(frame-2)) * bpy.context.scene.render.fps * 3.6
            else:
                speed_before = 0.0#speed
        else:
            speed = 0.0
            speed_before = 0.0
            acc = 0.0      
        diff = (speed - speed_before) * .1
        smooth_duration = car.sna_cr_interpol_duration
        if frame == bpy.context.scene.frame_start:
            car.sna_cr_frame_interpol = -1
        bpy.context.view_layer.update()
        if speed == 0:
            if speed_before == 0: ### voiture en arret
                car.sna_debug_state = 'STOP'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                if car.sna_cr_frame_interpol > 0: ### amortie de l'arret
                    if frame > car.sna_cr_frame_interpol+smooth_duration: #### fin amortie arret
                        car.sna_cr_frame_interpol = -1
                        acceleration = 0.0
                        car.sna_debug_state = 'STOP-INTERPOL-end'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                    else: #### en cours d'amortie d'arret
                        acceleration = acc * bl_math.smoothstep(car.sna_cr_frame_interpol+smooth_duration,car.sna_cr_frame_interpol-1,frame) 
                        car.sna_debug_state = 'STOP-INTERPOL'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
            else: ### première clé de stop
                car.sna_cr_frame_interpol = frame
                car.sna_cr_interpol_duration = max(1,int(acc * 6)) * car.sna_cr_interpol_duration_factor
                smooth_duration = car.sna_cr_interpol_duration
                acceleration = acc * bl_math.smoothstep(car.sna_cr_frame_interpol+smooth_duration,car.sna_cr_frame_interpol-1,frame) 
                car.sna_debug_state = 'STOP-INTERPOL-start'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
        else:
            if speed_before == 0: ### voiture démarre
                car.sna_cr_frame_interpol = frame
                car.sna_cr_interpol_duration = max(1,int( abs(speed) )) * car.sna_cr_interpol_duration_factor
                smooth_duration = car.sna_cr_interpol_duration
                acceleration = diff * bl_math.smoothstep(car.sna_cr_frame_interpol-1,car.sna_cr_frame_interpol+smooth_duration,frame) 
                car.sna_debug_state = 'RUN-INTERPOL-start' #+ '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
            else:
                if car.sna_cr_frame_interpol > 0: ### fin amortie de depart
                    if frame > car.sna_cr_frame_interpol+smooth_duration: #### fin amortie de depart
                        car.sna_cr_frame_interpol = -1
                        acceleration = diff
                        car.sna_debug_state = 'RUN-INTERPOL-end'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                    else: ### en cours d'amortie de depart
                        acceleration = diff * bl_math.smoothstep(car.sna_cr_frame_interpol-1,car.sna_cr_frame_interpol+smooth_duration,frame) 
                        car.sna_debug_state = 'RUN-INTERPOL'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                else:
                    acceleration = diff
                    car.sna_debug_state = 'RUN'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
    else:
        speed = 0.0
    ########################## NEW ACC/ DE-ACC ###################
    #carrig.pose.bones['AVG.steer_sp_rest_pose'].locatoin.y = 
    list(self.sna_cr_id_collec)[0].rig.pose.bones['main_drive'].constraints['Follow Path'].offset_factor = offset_factor
    self.sna_cr_instant_speed = speed
    carrig = list(self.sna_cr_id_collec)[0].rig
    import math
    from numpy import dot

    def get_bone_pose_matrix_cleaned(bone):
        # note that lack the scale (i'm not sure how make it)
        offset_m4 = (Matrix.Translation(bone.location) @ Quaternion(bone.rotation_quaternion).to_matrix().to_4x4())
        return bone.matrix @ offset_m4.inverted()

    def set_bone_world_position(bone, arm, worldPosition):
        return get_bone_pose_matrix_cleaned(bone).inverted() @ arm.matrix_world.inverted() @ worldPosition
    s = bpy.context.scene
    for sp_bone_item in carrig.sna_cr_sb_spring_bones_col:
        ###### select bones utiles en fonction du nom du bone string:
        sp_rest_pose = sp_bone_item.bone_spring_name + '_sp_rest_pose'
        sp_to_track_to = sp_bone_item.bone_spring_name + '_sp_to_track_to'
        bone_target_spring = carrig.pose.bones[sp_rest_pose]     
        bone_track_spring = carrig.pose.bones[sp_to_track_to]
        ############################################################
        ############## mettre à zéro en début de timeline
        sp_bone_item.speed_spring = Vector((0.0,0.0,0.0))          
        bone_target_spring_world_matrix = carrig.matrix_world @ bone_target_spring.matrix
        bone_target_spring_loc, rot, scale = bone_target_spring_world_matrix.decompose()
        bone_track_spring.location = set_bone_world_position(bone_track_spring, carrig, bone_target_spring_loc)     
    bpy.context.view_layer.update() 
    car = self
    bpy.context.view_layer.update()
    path = car.sna_cr_carrig_curve
    curve_len = path.data.splines[0].calc_length()
    carrig = car.sna_cr_id_collec[0].rig
    carrig["CarRig_path_len"] = path.data.splines[0].calc_length()
    main_offset = carrig.pose.bones['main_drive'].constraints["Follow Path"].offset_factor
    scale = carrig.pose.bones['main_drive_scale'].scale.x
    ##### .1*45.50459289550781*0.4395 = 1.9999268577575686 donc 2 !
    steer_offset = main_offset+scale*2/curve_len
    carrig.pose.bones['steering'].constraints["Follow Path"].offset_factor = steer_offset
    bpy.context.view_layer.update()
    carrig.pose.bones['main_target'].constraints["Follow Path"].offset_factor = main_offset*.35 + steer_offset*.65
    bpy.context.view_layer.update()


def sna_update_sna_cr_counter_steering_A8CCC(self, context):
    sna_updated_prop = self.sna_cr_counter_steering
    carrig = list(self.sna_cr_id_collec)[0].rig
    car = self
    angle = sna_updated_prop
    AVG_steer_bone = carrig.pose.bones['AVG.W.steer.over']
    AVD_steer_bone = carrig.pose.bones['AVD.W.steer.over']
    AVG_steer_bone.rotation_axis_angle[0] = car.sna_cr_counter_steering
    AVD_steer_bone.rotation_axis_angle[0] = car.sna_cr_counter_steering
    bpy.context.view_layer.update()


def sna_update_sna_cr_jump_fr_34090(self, context):
    sna_updated_prop = self.sna_cr_jump_fr
    carrig = list(self.sna_cr_id_collec)[0].rig
    car = self
    jump_fr_bone = carrig.pose.bones['axis_fr']
    jump_bk_bone = carrig.pose.bones['axis_bk']
    #bank_bone = carrig.pose.bones['body_bank']
    jump_fr_bone.location.z = - car.sna_cr_jump_fr*2
    jump_bk_bone.location.z = - car.sna_cr_jump_bk*2
    bpy.context.view_layer.update()


def sna_update_sna_cr_jump_bk_37550(self, context):
    sna_updated_prop = self.sna_cr_jump_bk
    carrig = list(self.sna_cr_id_collec)[0].rig
    car = self
    jump_fr_bone = carrig.pose.bones['axis_fr']
    jump_bk_bone = carrig.pose.bones['axis_bk']
    #bank_bone = carrig.pose.bones['body_bank']
    jump_fr_bone.location.z = - car.sna_cr_jump_fr*2
    jump_bk_bone.location.z = - car.sna_cr_jump_bk*2
    bpy.context.view_layer.update()


def sna_update_sna_cr_drift_025AD(self, context):
    sna_updated_prop = self.sna_cr_drift
    carrig = list(self.sna_cr_id_collec)[0].rig
    car = self
    drift_bone = carrig.pose.bones['drift']
    drift_bone.location.z = - car.sna_cr_drift
    drift_bank = abs(car.sna_cr_drift*.001)
    carrig['CarRig_Drift'] = car.sna_cr_drift
    bpy.context.view_layer.update() 


class dotdict(dict):
    __getattr__ = dict.get
    __setattr__ = dict.__setitem__
    __delattr__ = dict.__delitem__


def sna_get_outliner_collection_C555D_702CC(object):
    object = object
    collection_name = None
    collection_name = object.users_collection[0].name
    return collection_name


def sna_move_outliner_collection_object_A90B9_4CCDB(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_move_outliner_collection_object_A90B9_E6A72(object, collection_name):
    object = object
    collection_name = collection_name
    object_old_coll = object.users_collection
    collection = bpy.data.collections.get( collection_name )
    if collection not in object_old_coll:
        if collection is None:
            collection = bpy.data.collections.new( collection_name )
            bpy.context.scene.collection.children.link( collection )
        collection.objects.link( object )
        for coll in object_old_coll:
            coll.objects.unlink(object)


def sna_interface_about_pictofilmo_5B4B0(layout_function, ):
    row_E0127 = layout_function.row(heading='', align=True)
    row_E0127.alert = False
    row_E0127.enabled = True
    row_E0127.active = True
    row_E0127.use_property_split = False
    row_E0127.use_property_decorate = False
    row_E0127.scale_x = 1.0
    row_E0127.scale_y = 1.0
    row_E0127.alignment = 'Expand'.upper()
    if not True: row_E0127.operator_context = "EXEC_DEFAULT"
    row_E0127.template_icon(icon_value=_icons['pictofilmo_icon_128.png'].icon_id, scale=2.0)
    row_6FD3C = row_E0127.row(heading='', align=True)
    row_6FD3C.alert = False
    row_6FD3C.enabled = True
    row_6FD3C.active = True
    row_6FD3C.use_property_split = False
    row_6FD3C.use_property_decorate = False
    row_6FD3C.scale_x = 1.0
    row_6FD3C.scale_y = 2.0
    row_6FD3C.alignment = 'Expand'.upper()
    if not True: row_6FD3C.operator_context = "EXEC_DEFAULT"
    op = row_6FD3C.operator('sna.kb_op_web_link_8f33d', text='Picto Filmo', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'http://www.pictofilmo.com'
    row_A04F5 = layout_function.row(heading='', align=True)
    row_A04F5.alert = False
    row_A04F5.enabled = True
    row_A04F5.active = True
    row_A04F5.use_property_split = False
    row_A04F5.use_property_decorate = False
    row_A04F5.scale_x = 1.0
    row_A04F5.scale_y = 1.0
    row_A04F5.alignment = 'Expand'.upper()
    if not True: row_A04F5.operator_context = "EXEC_DEFAULT"
    row_A04F5.template_icon(icon_value=_icons['Blender+Market_ico_128.png'].icon_id, scale=1.0)
    row_FB09E = row_A04F5.row(heading='', align=True)
    row_FB09E.alert = False
    row_FB09E.enabled = True
    row_FB09E.active = True
    row_FB09E.use_property_split = False
    row_FB09E.use_property_decorate = False
    row_FB09E.scale_x = 1.0
    row_FB09E.scale_y = 1.0
    row_FB09E.alignment = 'Expand'.upper()
    if not True: row_FB09E.operator_context = "EXEC_DEFAULT"
    op = row_FB09E.operator('sna.kb_op_web_link_8f33d', text='Blender Market', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'https://blendermarket.com/creators/picto-filmo'
    row_A16FF = layout_function.row(heading='', align=True)
    row_A16FF.alert = False
    row_A16FF.enabled = True
    row_A16FF.active = True
    row_A16FF.use_property_split = False
    row_A16FF.use_property_decorate = False
    row_A16FF.scale_x = 1.0
    row_A16FF.scale_y = 1.0
    row_A16FF.alignment = 'Expand'.upper()
    if not True: row_A16FF.operator_context = "EXEC_DEFAULT"
    row_A16FF.template_icon(icon_value=_icons['gumraod_icon_128.png'].icon_id, scale=1.0)
    row_8A16E = row_A16FF.row(heading='', align=True)
    row_8A16E.alert = False
    row_8A16E.enabled = True
    row_8A16E.active = True
    row_8A16E.use_property_split = False
    row_8A16E.use_property_decorate = False
    row_8A16E.scale_x = 1.0
    row_8A16E.scale_y = 1.0
    row_8A16E.alignment = 'Expand'.upper()
    if not True: row_8A16E.operator_context = "EXEC_DEFAULT"
    op = row_8A16E.operator('sna.kb_op_web_link_8f33d', text='Gumroad', icon_value=0, emboss=True, depress=False)
    op.sna_weblink = 'https://pictofilmo.gumroad.com/'


class SNA_OT_Kb_Op_Web_Link_8F33D(bpy.types.Operator):
    bl_idname = "sna.kb_op_web_link_8f33d"
    bl_label = "KB_OP_Web_Link"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_weblink: bpy.props.StringProperty(name='WebLink', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        webpath = self.sna_weblink
        webbrowser.open(webpath)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Cr_Op_Fiil_Spring_List_Afd4A(bpy.types.Operator):
    bl_idname = "sna.cr_op_fiil_spring_list_afd4a"
    bl_label = "CR_OP_Fiil_spring_list"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_rig_name: bpy.props.StringProperty(name='rig_name', description='', default='', subtype='NONE', maxlen=0)

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        bpy.data.objects[self.sna_rig_name].sna_cr_sb_spring_bones_col.clear()
        carrig = bpy.data.objects[self.sna_rig_name]
        spring_bones_list = None

        def find_bone_names_by_group(Pose, GroupName): #renvoie la liste des bones de Pose.bones faisant partie du group de bones "GroupName"
            result = []
            for b in Pose.bones:
                if hasattr( b.bone_group, "name"):
                    if b.bone_group.name == GroupName:
                        result.append(b.bone.name)
            return result
        spring_bones_list = find_bone_names_by_group(carrig.pose, 'spring')
        for i_5087D in range(len(spring_bones_list)):
            item_F4889 = bpy.data.objects[self.sna_rig_name].sna_cr_sb_spring_bones_col.add()
            item_F4889.bone_spring_name = spring_bones_list[i_5087D]
            item_F4889.speed_spring = (0.0, 0.0, 0.0)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Cr_Op_Clone_Rigicar_42D39(bpy.types.Operator):
    bl_idname = "sna.cr_op_clone_rigicar_42d39"
    bl_label = "CR_OP_Clone_RigiCar"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):

        def select_active(ob):
            ob.select_set(True)
            bpy.context.view_layer.objects.active = ob
        car = bpy.context.object
        car_id = car.sna_cr_id_collec
        try:
            bpy.ops.object.select_all(action='DESELECT')
            select_active(car_id[0].path_curve)
            bpy.ops.object.duplicate_move(OBJECT_OT_duplicate={"linked":False, "mode":'TRANSLATION'}, TRANSFORM_OT_translate={"value":(0, 0, 0), "orient_axis_ortho":'X', "orient_type":'GLOBAL', "orient_matrix":((0, 0, 0), (0, 0, 0), (0, 0, 0)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "view2d_edge_pan":False, "release_confirm":False, "use_accurate":False, "use_automerge_and_split":False})
            new_default_curve = bpy.context.object
        except:
            print('no default path')    
        try:
            if car_id[0].path_curve != car.sna_cr_carrig_curve:
                bpy.ops.object.select_all(action='DESELECT')     
                select_active(car.sna_cr_carrig_curve)
                bpy.ops.object.duplicate_move(OBJECT_OT_duplicate={"linked":False, "mode":'TRANSLATION'}, TRANSFORM_OT_translate={"value":(0, 0, 0), "orient_axis_ortho":'X', "orient_type":'GLOBAL', "orient_matrix":((0, 0, 0), (0, 0, 0), (0, 0, 0)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "view2d_edge_pan":False, "release_confirm":False, "use_accurate":False, "use_automerge_and_split":False})
                new_curve = bpy.context.object
            else:
                new_curve = new_default_curve
        except:
            print('no path')
        bpy.ops.object.select_all(action='DESELECT')
        #select_active(car)
        try:
            car.sna_cr_wheel_avg.hide_select = False
        except:
            print('no ref wheel')
        try:
            car_id[0].wheel_avd.hide_select = False
            car_id[0].wheel_ard.hide_select = False
            car_id[0].wheel_arg.hide_select = False
        except:
            print('no wheel')
        bpy.ops.object.select_all(action='DESELECT')
        car_rig = car_id[0].rig
        car_rig.hide_viewport = False
        car_rig.hide_select = False
        select_active(car_rig)
        bpy.ops.object.mode_set(mode = 'OBJECT')
        bpy.ops.object.select_grouped(type='CHILDREN_RECURSIVE')
        select_active(car_rig)
        bpy.ops.object.duplicate_move(OBJECT_OT_duplicate={"linked":False, "mode":'TRANSLATION'}, TRANSFORM_OT_translate={"value":(0, 0, 0), "orient_axis_ortho":'X', "orient_type":'GLOBAL', "orient_matrix":((0, 0, 0), (0, 0, 0), (0, 0, 0)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "view2d_edge_pan":False, "release_confirm":False, "use_accurate":False, "use_automerge_and_split":False})
        for ob in bpy.context.selected_objects:
            if ob.sna_cr_bool:
                new_car = ob
        new_car_id = new_car.sna_cr_id_collec
        try:
            new_car_id[0].wheel_avd.hide_select = True
            new_car_id[0].wheel_ard.hide_select = True
            new_car_id[0].wheel_arg.hide_select = True
        except:
            print('no wheel')
        try:
            car_id[0].wheel_avd.hide_select = True
            car_id[0].wheel_ard.hide_select = True
            car_id[0].wheel_arg.hide_select = True
        except:
            print('no wheel')
        try:
            new_car_id[0].path_curve = new_default_curve
        except:
            print('no default path')
        bpy.ops.object.select_all(action='DESELECT')
        #select_active(new_car_id[0].path_curve)
        new_car.sna_cr_carrig_curve = new_curve
        select_active(new_car.sna_cr_carrig_curve)
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Cr_Op_Bake_2_Meshes_8F15D(bpy.types.Operator):
    bl_idname = "sna.cr_op_bake_2_meshes_8f15d"
    bl_label = "CR_OP_Bake_2_Meshes"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    def sna_all_enum_items(self, context):
        return [("No Items", "No Items", "No generate enum items node found to create items!", "ERROR", 0)]
    sna_all: bpy.props.EnumProperty(name='all', description='', items=[('Selected RigiCar', 'Selected RigiCar', '', 0, 0), ('All RigiCars', 'All RigiCars', '', 0, 1)])
    sna_start: bpy.props.IntProperty(name='start', description='', default=0, subtype='NONE')
    sna_end: bpy.props.IntProperty(name='end', description='', default=0, subtype='NONE')

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        collection_name_0_7a449 = sna_get_outliner_collection_C555D_7A449(bpy.context.view_layer.objects.active)
        carrig_setup['sna_collection_name_tmp'] = collection_name_0_7a449
        sna_move_outliner_collection_object_A90B9_17144(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_avd, carrig_setup['sna_collection_name_tmp'])
        sna_move_outliner_collection_object_A90B9_EC909(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_ard, carrig_setup['sna_collection_name_tmp'])
        sna_move_outliner_collection_object_A90B9_3369A(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_arg, carrig_setup['sna_collection_name_tmp'])
        start = self.sna_start
        end = self.sna_end
        all = self.sna_all

        def select_active(ob):
            ob.select_set(True)
            bpy.context.view_layer.objects.active = ob
        active_car = bpy.context.object
        if all == 'Selected RigiCar':
            car = bpy.context.object
            car_id = car.sna_cr_id_collec
            try:
                car.sna_cr_wheel_avg.hide_select = False
            except:
                print('no ref wheel')
            try:
                car_id[0].wheel_avd.hide_select = False
                #car_id[0].wheel_avd.select_set(True)
                car_id[0].wheel_ard.hide_select = False
                #car_id[0].wheel_ard.select_set(True)
                car_id[0].wheel_arg.hide_select = False
                #car_id[0].wheel_arg.select_set(True)
            except:
                print('no wheel')
            bpy.ops.object.select_all(action='DESELECT')
            car_rig = car_id[0].rig
            car_rig.hide_viewport = False
            car_rig.hide_select = False
            select_active(car_rig)
            bpy.ops.object.mode_set(mode = 'OBJECT')
            bpy.ops.object.select_grouped(type='CHILDREN_RECURSIVE')
            bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
            bpy.ops.nla.bake(frame_start=start, frame_end=end, only_selected=False, visual_keying=True, clear_parents=True, bake_types={'OBJECT'})
            car.sna_cr_bool = False
            bpy.ops.object.select_all(action='DESELECT')
            try:
                car_id[0].rig.select_set(True)
            except:
                print('no car_rig')
            try:        
                car_id[0].path_curve.select_set(True)
            except:
                print('no path_curve')
        else:
            list_car = []
            list_ob_to_bake = []
            bpy.ops.object.select_all(action='DESELECT')
            for car in bpy.data.objects:
                if car.sna_cr_bool:
                    list_car.append(car)
                    car_id = car.sna_cr_id_collec
                    try:
                        car.sna_cr_wheel_avg.hide_select = False
                    except:
                        print('no ref wheel')
                    try:
                        car_id[0].wheel_avd.hide_select = False
                        #car_id[0].wheel_avd.select_set(True)
                        car_id[0].wheel_ard.hide_select = False
                        #car_id[0].wheel_ard.select_set(True)
                        car_id[0].wheel_arg.hide_select = False
                        #car_id[0].wheel_arg.select_set(True)
                    except:
                        print('no wheel')
                    bpy.ops.object.select_all(action='DESELECT')
                    car_rig = car_id[0].rig
                    car_rig.hide_viewport = False
                    car_rig.hide_select = False
                    select_active(car_rig)
                    bpy.ops.object.mode_set(mode = 'OBJECT')
                    bpy.ops.object.select_grouped(type='CHILDREN_RECURSIVE')
                    for o in bpy.context.selected_objects:
                        list_ob_to_bake.append(o)
            bpy.ops.object.select_all(action='DESELECT')
            for o in list_ob_to_bake:
                o.select_set(True)
            bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
            bpy.ops.nla.bake(frame_start=start, frame_end=end, only_selected=False, visual_keying=True, clear_parents=True, bake_types={'OBJECT'})
            bpy.ops.object.select_all(action='DESELECT')
            for car in list_car:
                car_id = car.sna_cr_id_collec
                car.sna_cr_bool = False
                try:
                    car_id[0].rig.select_set(True)
                except:
                    print('no car_rig')
                try:        
                    car_id[0].path_curve.select_set(True)
                except:
                    print('no path_curve')
        ###### common commands
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]
        bpy.ops.object.delete()
        select_active(active_car)
        return {"FINISHED"}

    def draw(self, context):
        layout = self.layout
        layout.label(text='This Will Kill RigiCar Setup !', icon_value=2)
        row_4F780 = layout.row(heading='', align=False)
        row_4F780.alert = False
        row_4F780.enabled = True
        row_4F780.active = True
        row_4F780.use_property_split = False
        row_4F780.use_property_decorate = False
        row_4F780.scale_x = 1.0
        row_4F780.scale_y = 1.0
        row_4F780.alignment = 'Expand'.upper()
        if not True: row_4F780.operator_context = "EXEC_DEFAULT"
        row_4F780.prop(self, 'sna_start', text='start', icon_value=0, emboss=True)
        row_4F780.prop(self, 'sna_end', text='end', icon_value=0, emboss=True)
        row_A478A = layout.row(heading='', align=False)
        row_A478A.alert = False
        row_A478A.enabled = True
        row_A478A.active = True
        row_A478A.use_property_split = False
        row_A478A.use_property_decorate = False
        row_A478A.scale_x = 1.0
        row_A478A.scale_y = 1.0
        row_A478A.alignment = 'Expand'.upper()
        if not True: row_A478A.operator_context = "EXEC_DEFAULT"
        row_A478A.label(text='', icon_value=1)
        row_A478A.prop(self, 'sna_all', text=self.sna_all, icon_value=0, emboss=True, expand=True, toggle=True)

    def invoke(self, context, event):
        self.sna_start = bpy.context.scene.frame_start
        self.sna_end = bpy.context.scene.frame_end
        return context.window_manager.invoke_props_dialog(self, width=300)


class SNA_OT_Cr_Op_Setup_Wheels_24503(bpy.types.Operator):
    bl_idname = "sna.cr_op_setup_wheels_24503"
    bl_label = "CR_OP_Setup_Wheels"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        car = bpy.context.view_layer.objects.active
        carrig = list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig

        def select_active(ob):
            ob.select_set(True)
            bpy.context.view_layer.objects.active = ob
        wheel = car.sna_cr_wheel_avg
        wheel.rotation_mode = 'XYZ'
        wheel.rotation_euler[0] = 0
        wheel.rotation_euler[1] = 0
        wheel.rotation_euler[2] = 0
        wheel['previous_loc'] = (0.0,0.0,0.0)
        wheel['previous_angle'] = 0.0
        #carrig = car.sna_cr_id_collec[0].rig
        carrig_bones = carrig.pose.bones
        carrig_bones['AVG.steer.W'].scale = (1,1,1)
        carrig_bones['AVD.steer.W'].scale = (1,1,1)
        carrig_bones['ARD.W'].scale = (1,1,1)
        carrig_bones['ARG.W'].scale = (1,1,1)
        car.sna_cr_wheel_scale = 1.0
        ### calcul rayon roue:
        dim = wheel.dimensions.x
        if wheel.dimensions.y > dim:
            dim = wheel.dimensions.y
        if wheel.dimensions.z > dim:
            dim = wheel.dimensions.z            
        car.sna_cr_wheel_radius = dim / 2
        bpy.ops.object.select_all(action='DESELECT')
        select_active(wheel)
        ############## problem si animation keys sur les roues #########################
        try:
            fc = wheel.animation_data.action.fcurves
            for f in fc:
                fc.remove(f)
        except:
            print("no animation data")
        bpy.context.scene.tool_settings.use_keyframe_insert_auto = False
        #################################################################################
        #### voiture parent du bone body.damped
        wheel.location = (0,0,0)
        wheel.parent = carrig
        wheel.parent_type = 'BONE'
        wheel.parent_bone = 'AVG.steer.W'
        carrig_bones['AVG.steer.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
        #carrig_bones['AVG.steer_sp_rest_pose'].location = carrig_bones['AVG.steer.W'].location
        car_id = car.sna_cr_id_collec
        ##################################  wheel_avd
        bpy.ops.object.duplicate_move_linked(
                                OBJECT_OT_duplicate={"linked":True, "mode":'TRANSLATION'}, 
                                TRANSFORM_OT_translate={"value":(0, 0, 0), 
                                                        "orient_axis_ortho":'X', 
                                                        "orient_type":'GLOBAL', 
                                                        "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), 
                                                        "orient_matrix_type":'GLOBAL', 
                                                        "constraint_axis":(False, False, False), 
                                                        "mirror":False, 
                                                        "use_proportional_edit":False, 
                                                        "proportional_edit_falloff":'SMOOTH', 
                                                        "proportional_size":1, 
                                                        "use_proportional_connected":False, 
                                                        "use_proportional_projected":False, 
                                                        "snap":False, 
                                                        "snap_target":'CLOSEST', 
                                                        "snap_point":(0, 0, 0), 
                                                        "snap_align":False, 
                                                        "snap_normal":(0, 0, 0), 
                                                        "gpencil_strokes":False, 
                                                        "cursor_transform":False, 
                                                        "texture_space":False, 
                                                        "remove_on_cancel":False, 
                                                        "view2d_edge_pan":False, 
                                                        "release_confirm":False, 
                                                        "use_accurate":False, 
                                                        "use_automerge_and_split":False})
        bpy.context.object.name = wheel.name + '_avd'
        car_id[0].wheel_avd = bpy.context.object
        car_id[0].wheel_avd['previous_loc'] = (0.0,0.0,0.0)
        car_id[0].wheel_avd.hide_select = True
        car_id[0].wheel_avd.parent = carrig
        car_id[0].wheel_avd.parent_type = 'BONE'
        car_id[0].wheel_avd.parent_bone = 'AVD.steer.W'
        carrig_bones['AVD.steer.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
        #carrig_bones['AVD.steer_sp_rest_pose'].location = carrig_bones['AVD.steer.W'].location
        bpy.ops.object.select_all(action='DESELECT')
        ############################## wheel_ard
        select_active(wheel)
        bpy.ops.object.duplicate_move_linked(
                                OBJECT_OT_duplicate={"linked":True, "mode":'TRANSLATION'}, 
                                TRANSFORM_OT_translate={"value":(0, 0, 0), 
                                                        "orient_axis_ortho":'X', 
                                                        "orient_type":'GLOBAL', 
                                                        "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), 
                                                        "orient_matrix_type":'GLOBAL', 
                                                        "constraint_axis":(False, False, False), 
                                                        "mirror":False, 
                                                        "use_proportional_edit":False, 
                                                        "proportional_edit_falloff":'SMOOTH', 
                                                        "proportional_size":1, 
                                                        "use_proportional_connected":False, 
                                                        "use_proportional_projected":False, 
                                                        "snap":False, 
                                                        "snap_target":'CLOSEST', 
                                                        "snap_point":(0, 0, 0), 
                                                        "snap_align":False, 
                                                        "snap_normal":(0, 0, 0), 
                                                        "gpencil_strokes":False, 
                                                        "cursor_transform":False, 
                                                        "texture_space":False, 
                                                        "remove_on_cancel":False, 
                                                        "view2d_edge_pan":False, 
                                                        "release_confirm":False, 
                                                        "use_accurate":False, 
                                                        "use_automerge_and_split":False})
        bpy.context.object.name = wheel.name + '_ard'
        car_id[0].wheel_ard = bpy.context.object
        car_id[0].wheel_ard['previous_loc'] = (0.0,0.0,0.0)
        car_id[0].wheel_ard.hide_select = True
        car_id[0].wheel_ard.parent = carrig
        car_id[0].wheel_ard.parent_type = 'BONE'
        car_id[0].wheel_ard.parent_bone = 'ARD.W'
        carrig_bones['ARD.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
        #carrig_bones['ARD_sp_rest_pose'].location = carrig_bones['ARD.W'].location
        bpy.ops.object.select_all(action='DESELECT')
        ############################## wheel_arg
        select_active(wheel)
        bpy.ops.object.duplicate_move_linked(
                                OBJECT_OT_duplicate={"linked":True, "mode":'TRANSLATION'}, 
                                TRANSFORM_OT_translate={"value":(0, 0, 0), 
                                                        "orient_axis_ortho":'X', 
                                                        "orient_type":'GLOBAL', 
                                                        "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), 
                                                        "orient_matrix_type":'GLOBAL', 
                                                        "constraint_axis":(False, False, False), 
                                                        "mirror":False, 
                                                        "use_proportional_edit":False, 
                                                        "proportional_edit_falloff":'SMOOTH', 
                                                        "proportional_size":1, 
                                                        "use_proportional_connected":False, 
                                                        "use_proportional_projected":False, 
                                                        "snap":False, 
                                                        "snap_target":'CLOSEST', 
                                                        "snap_point":(0, 0, 0), 
                                                        "snap_align":False, 
                                                        "snap_normal":(0, 0, 0), 
                                                        "gpencil_strokes":False, 
                                                        "cursor_transform":False, 
                                                        "texture_space":False, 
                                                        "remove_on_cancel":False, 
                                                        "view2d_edge_pan":False, 
                                                        "release_confirm":False, 
                                                        "use_accurate":False, 
                                                        "use_automerge_and_split":False})
        bpy.context.object.name = wheel.name + '_arg'
        car_id[0].wheel_arg = bpy.context.object
        car_id[0].wheel_arg['previous_loc'] = (0.0,0.0,0.0)
        car_id[0].wheel_arg.hide_select = True
        car_id[0].wheel_arg.parent = carrig
        car_id[0].wheel_arg.parent_type = 'BONE'
        car_id[0].wheel_arg.parent_bone = 'ARG.W'
        carrig_bones['ARG.W'].location = (0.0,0.0,car.sna_cr_wheel_radius)
        #carrig_bones['ARG_sp_rest_pose'].location = carrig_bones['ARG.W'].location
        bpy.ops.object.select_all(action='DESELECT')
        #########################################################
        select_active(car)
        sna_move_outliner_collection_object_A90B9_086DB(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_avd, 'RigiCar_Collection')
        sna_move_outliner_collection_object_A90B9_E1FB8(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_ard, 'RigiCar_Collection')
        sna_move_outliner_collection_object_A90B9_A4559(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].wheel_arg, 'RigiCar_Collection')
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Cr_Op_Turn_Car_Direction_97B1F(bpy.types.Operator):
    bl_idname = "sna.cr_op_turn_car_direction_97b1f"
    bl_label = "CR_OP_Turn_car_direction"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    def sna_orient_enum_items(self, context):
        return [("No Items", "No Items", "No generate enum items node found to create items!", "ERROR", 0)]
    sna_orient: bpy.props.EnumProperty(name='orient', description='', items=[('XY', 'XY', '', 0, 0), ('YZ', 'YZ', '', 0, 1), ('ZX', 'ZX', '', 0, 2)])

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        car = bpy.context.view_layer.objects.active
        direction = self.sna_orient
        from math import pi

        def bone_world_matrix(rig, bone):
            return rig.matrix_world@bone.matrix
        #décompose matrice world:
        orig_loc, orig_rot, orig_scale = ob.matrix_world.decompose()
        local_axis_global_coords = Vector((0.0,0.0,0.0))
        #Marice translation:
        orig_loc_mat = Matrix.Translation(orig_loc)
        #Marice rotation:
        orig_rot_mat = orig_rot.to_matrix().to_4x4()
        #Marice scale:
        orig_scale_mat = Matrix.Scale(orig_scale[0],4,(1,0,0)) * Matrix.Scale(orig_scale[1],4,(0,1,0)) * Matrix.Scale(orig_scale[2],4,(0,0,1))
        normalize_matrix_world = ob.matrix_world.normalized()
        if direction == 'YZ':
            local_axis_global_coords = [row[2] for row in normalize_matrix_world[:3]]
        elif direction == 'ZX':
            local_axis_global_coords = [row[0] for row in normalize_matrix_world[:3]]
        elif direction == 'XY':
            local_axis_global_coords = [row[1] for row in normalize_matrix_world[:3]]
        rot_mat = Matrix.Rotation(pi/2, 4, local_axis_global_coords)
        ob.matrix_world = orig_loc_mat @ rot_mat @ orig_rot_mat @ orig_scale_mat
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


@persistent
def render_init_handler_B0A44(dummy):
    carrig_setup['sna_rendering_state'] = True


def sna_rc_fu_test_rigicar_6C34F():
    return (True if (len(list(bpy.context.view_layer.objects.selected)) < 1) else (not bpy.context.view_layer.objects.active.sna_cr_bool))


class SNA_PT_RIGICAR_13EF3(bpy.types.Panel):
    bl_label = 'RigiCar'
    bl_idname = 'SNA_PT_RIGICAR_13EF3'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_category = 'RigiCar'
    bl_order = 0
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout

    def draw(self, context):
        layout = self.layout
        row_A0A33 = layout.row(heading='', align=False)
        row_A0A33.alert = False
        row_A0A33.enabled = True
        row_A0A33.active = True
        row_A0A33.use_property_split = False
        row_A0A33.use_property_decorate = False
        row_A0A33.scale_x = 1.0
        row_A0A33.scale_y = 1.0
        row_A0A33.alignment = 'Expand'.upper()
        op = row_A0A33.operator('sna.cr_op_toggle_90495', text='RigiCar', icon_value=37, emboss=True, depress=(not sna_rc_fu_test_rigicar_6C34F()))
        if (not sna_rc_fu_test_rigicar_6C34F()):
            row_B562A = row_A0A33.row(heading='', align=False)
            row_B562A.alert = False
            row_B562A.enabled = True
            row_B562A.active = True
            row_B562A.use_property_split = False
            row_B562A.use_property_decorate = False
            row_B562A.scale_x = 1.0
            row_B562A.scale_y = 1.0
            row_B562A.alignment = 'Expand'.upper()
            op = row_B562A.operator('sna.cr_op_clone_rigicar_42d39', text='Clone', icon_value=20, emboss=True, depress=False)
            op = row_B562A.operator('sna.cr_op_copy_parametters_18d32', text='Copy', icon_value=598, emboss=True, depress=False)
            if carrig_setup['sna_cr_param_buffer']:
                op = row_B562A.operator('sna.cr_op_paste_parametters_52b4d', text='', icon_value=599, emboss=True, depress=False)
                op.sna_all_cars = 'Selected RigiCar'
        if (((not ('(' + os.path.basename(os.path.join(os.path.dirname(__file__), 'assets', 'rigicar_assets_2.1.3.blend')).split('.blend')[0][15:].replace('.', ', ') + ')' == list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig['CarRig_ver'])) if property_exists("list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig['CarRig_ver']", globals(), locals()) else True) and bpy.context.view_layer.objects.active.sna_cr_bool):
            row_37D1A = layout.row(heading='', align=False)
            row_37D1A.alert = True
            row_37D1A.enabled = True
            row_37D1A.active = True
            row_37D1A.use_property_split = False
            row_37D1A.use_property_decorate = False
            row_37D1A.scale_x = 1.0
            row_37D1A.scale_y = 1.0
            row_37D1A.alignment = 'Expand'.upper()
            if not True: row_37D1A.operator_context = "EXEC_DEFAULT"
            op = row_37D1A.operator('sna.cr_op_update_rigicar_model_94895', text='Update RigiCar to actual Addon', icon_value=0, emboss=True, depress=False)


@persistent
def frame_change_post_handler_B0813(dummy):
    sna_cr_fc_update_car_4E413()


@persistent
def render_cancel_handler_03D6E(dummy):
    carrig_setup['sna_rendering_state'] = False


@persistent
def render_complete_handler_13363(dummy):
    carrig_setup['sna_rendering_state'] = False


_F10C6_running = False
class SNA_OT_Cr_Mop_Algin_Wheels_F10C6(bpy.types.Operator):
    bl_idname = "sna.cr_mop_algin_wheels_f10c6"
    bl_label = "CR_MOP_Algin_Wheels"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_pos_x: bpy.props.IntProperty(name='pos_x', description='', default=0, subtype='NONE')
    sna_pos_y: bpy.props.IntProperty(name='pos_y', description='', default=0, subtype='NONE')
    cursor = "HAND"
    _handle = None
    _event = {}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        if not True or context.area.spaces[0].bl_rna.identifier == 'SpaceView3D':
            return not False
        return False

    def save_event(self, event):
        event_options = ["type", "value", "alt", "shift", "ctrl", "oskey", "mouse_region_x", "mouse_region_y", "mouse_x", "mouse_y", "pressure", "tilt"]
        if bpy.app.version >= (3, 2, 1):
            event_options += ["type_prev", "value_prev"]
        for option in event_options: self._event[option] = getattr(event, option)

    def draw_callback_px(self, context):
        event = self._event
        if event.keys():
            event = dotdict(event)
            try:
                font_id = 0
                if os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf') and os.path.exists(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf')):
                    font_id = blf.load(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf'))
                if font_id == -1:
                    print("Couldn't load font!")
                else:
                    x_F0F86, y_F0F86 = (int(int(self.sna_pos_x * 0.5) - 250.0), 150)
                    blf.position(font_id, x_F0F86, y_F0F86, 0)
                    if bpy.app.version >= (3, 4, 0):
                        blf.size(font_id, 30.0)
                    else:
                        blf.size(font_id, 30.0, 72)
                    clr = (1.0, 1.0, 1.0, 1.0)
                    blf.color(font_id, clr[0], clr[1], clr[2], clr[3])
                    if 500:
                        blf.enable(font_id, blf.WORD_WRAP)
                        blf.word_wrap(font_id, 500)
                    if False:
                        blf.enable(font_id, blf.ROTATION)
                        blf.rotation(font_id, 0)
                    blf.enable(font_id, blf.WORD_WRAP)
                    blf.draw(font_id, "press 'X' 'Y' 'Z' to align the model\npress 'Esc' to valid")
                    blf.disable(font_id, blf.ROTATION)
                    blf.disable(font_id, blf.WORD_WRAP)
                font_id = 0
                if os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf') and os.path.exists(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf')):
                    font_id = blf.load(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf'))
                if font_id == -1:
                    print("Couldn't load font!")
                else:
                    x_2F92F, y_2F92F = (int(int(self.sna_pos_x * 0.5) - 150.0), int(self.sna_pos_y - 150.0))
                    blf.position(font_id, x_2F92F, y_2F92F, 0)
                    if bpy.app.version >= (3, 4, 0):
                        blf.size(font_id, 30.0)
                    else:
                        blf.size(font_id, 30.0, 72)
                    clr = (0.21046176552772522, 0.4869038462638855, 0.8199999928474426, 1.0)
                    blf.color(font_id, clr[0], clr[1], clr[2], clr[3])
                    if 300:
                        blf.enable(font_id, blf.WORD_WRAP)
                        blf.word_wrap(font_id, 300)
                    if False:
                        blf.enable(font_id, blf.ROTATION)
                        blf.rotation(font_id, 0)
                    blf.enable(font_id, blf.WORD_WRAP)
                    blf.draw(font_id, 'Align Wheels Rotation')
                    blf.disable(font_id, blf.ROTATION)
                    blf.disable(font_id, blf.WORD_WRAP)
            except Exception as error:
                print(error)

    def execute(self, context):
        global _F10C6_running
        _F10C6_running = False
        context.window.cursor_set("DEFAULT")
        bpy.types.SpaceView3D.draw_handler_remove(self._handle, 'WINDOW')
        bpy.context.scene.sna_cr_modal_activ = False
        exec("bpy.context.scene.transform_orientation_slots[0].type = carrig_setup['sna_name_tmp'] ")
        for area in context.screen.areas:
            area.tag_redraw()
        return {"FINISHED"}

    def modal(self, context, event):
        global _F10C6_running
        if not context.area or not _F10C6_running:
            self.execute(context)
            return {'CANCELLED'}
        self.save_event(event)
        context.area.tag_redraw()
        context.window.cursor_set('HAND')
        try:
            ob = bpy.context.view_layer.objects.active.sna_cr_wheel_avg
            direction = ('YZ' if (event.type == 'Z' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else ('XY' if (event.type == 'Y' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else ('ZX' if (event.type == 'X' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else 'None')))
            from math import pi

            def bone_world_matrix(rig, bone):
                return rig.matrix_world@bone.matrix
            #décompose matrice world:
            orig_loc, orig_rot, orig_scale = ob.matrix_world.decompose()
            local_axis_global_coords = Vector((0.0,0.0,0.0))
            #Marice translation:
            orig_loc_mat = Matrix.Translation(orig_loc)
            #Marice rotation:
            orig_rot_mat = orig_rot.to_matrix().to_4x4()
            #Marice scale:
            orig_scale_mat = Matrix.Scale(orig_scale[0],4,(1,0,0)) * Matrix.Scale(orig_scale[1],4,(0,1,0)) * Matrix.Scale(orig_scale[2],4,(0,0,1))
            normalize_matrix_world = ob.matrix_world.normalized()
            if direction == 'YZ':
                local_axis_global_coords = [row[2] for row in normalize_matrix_world[:3]]
            elif direction == 'ZX':
                local_axis_global_coords = [row[0] for row in normalize_matrix_world[:3]]
            elif direction == 'XY':
                local_axis_global_coords = [row[1] for row in normalize_matrix_world[:3]]
            rot_mat = Matrix.Rotation(pi/2, 4, local_axis_global_coords)
            ob.matrix_world = orig_loc_mat @ rot_mat @ orig_rot_mat @ orig_scale_mat
            car = bpy.context.view_layer.objects.active
            wheel = bpy.context.view_layer.objects.active.sna_cr_wheel_avg
            car_id = car.sna_cr_id_collec
            car_id[0].wheel_avd.rotation_euler = wheel.rotation_euler
            car_id[0].wheel_ard.rotation_euler = wheel.rotation_euler
            car_id[0].wheel_arg.rotation_euler = wheel.rotation_euler
        except Exception as error:
            print(error)
        if event.type in ['RIGHTMOUSE', 'ESC']:
            self.execute(context)
            return {'CANCELLED'}
        return {'RUNNING_MODAL'}

    def invoke(self, context, event):
        global _F10C6_running
        if _F10C6_running:
            _F10C6_running = False
            return {'FINISHED'}
        else:
            self.save_event(event)
            self.start_pos = (event.mouse_x, event.mouse_y)
            exec("carrig_setup['sna_name_tmp'] = bpy.context.scene.transform_orientation_slots[0].type")
            self.report({'INFO'}, message='Align wheels !')
            bpy.context.scene.sna_cr_modal_activ = True
            areas = bpy.context.workspace.screens[0].areas
            for area in areas:
                for space in area.spaces:
                    if space.type == 'VIEW_3D':
                        space.show_gizmo_object_translate = True
                        space.show_gizmo = True
                        bpy.ops.wm.tool_set_by_id(name="builtin.move")
                        bpy.context.scene.transform_orientation_slots[0].type = 'LOCAL'
                        #space.region_3d.view_camera_zoom -= 20
            ########################################################
            #region_3d.view_camera_zoom += foo
            #bpy.data.scenes['Scene'].transform_orientation_slots[0].type
            #bpy.ops.view3d.view_selected(use_all_regions=False)
            #######################################################
            #v3d = [x for x in bpy.context.screen.areas if x.type == 'VIEW_3D']
            #if v3d:
            #    # you need to decide what to do if there are more than one 3D Views present
            #    # you could either set the orientation on the first one, or on a specific one
            #    # to set it on all views:
            #    for v in v3d:
            #        v.spaces[0].transform_orientation = 'LOCAL'
            posx = None
            posy = None
            for area in bpy.context.screen.areas:
                if area.type == 'VIEW_3D':
                    posx = int(area.width * 1)
                    posy = int(area.height * 1)
            self.sna_pos_x = posx
            self.sna_pos_y = posy
            args = (context,)
            self._handle = bpy.types.SpaceView3D.draw_handler_add(self.draw_callback_px, args, 'WINDOW', 'POST_PIXEL')
            context.window_manager.modal_handler_add(self)
            _F10C6_running = True
            return {'RUNNING_MODAL'}


_C9DCF_running = False
class SNA_OT_Cr_Mop_Algin_Car_C9Dcf(bpy.types.Operator):
    bl_idname = "sna.cr_mop_algin_car_c9dcf"
    bl_label = "CR_MOP_Algin_Car"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}
    sna_pos_x: bpy.props.IntProperty(name='pos_x', description='', default=500, subtype='NONE')
    sna_pos_y: bpy.props.IntProperty(name='pos_y', description='', default=500, subtype='NONE')
    cursor = "HAND"
    _handle = None
    _event = {}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        if not True or context.area.spaces[0].bl_rna.identifier == 'SpaceView3D':
            return not False
        return False

    def save_event(self, event):
        event_options = ["type", "value", "alt", "shift", "ctrl", "oskey", "mouse_region_x", "mouse_region_y", "mouse_x", "mouse_y", "pressure", "tilt"]
        if bpy.app.version >= (3, 2, 1):
            event_options += ["type_prev", "value_prev"]
        for option in event_options: self._event[option] = getattr(event, option)

    def draw_callback_px(self, context):
        event = self._event
        if event.keys():
            event = dotdict(event)
            try:
                font_id = 0
                if os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf') and os.path.exists(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf')):
                    font_id = blf.load(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf'))
                if font_id == -1:
                    print("Couldn't load font!")
                else:
                    x_C9BE5, y_C9BE5 = (int(int(self.sna_pos_x / 2.0) - 250.0), 150)
                    blf.position(font_id, x_C9BE5, y_C9BE5, 0)
                    if bpy.app.version >= (3, 4, 0):
                        blf.size(font_id, 30.0)
                    else:
                        blf.size(font_id, 30.0, 72)
                    clr = (1.0, 1.0, 1.0, 1.0)
                    blf.color(font_id, clr[0], clr[1], clr[2], clr[3])
                    if 500:
                        blf.enable(font_id, blf.WORD_WRAP)
                        blf.word_wrap(font_id, 500)
                    if False:
                        blf.enable(font_id, blf.ROTATION)
                        blf.rotation(font_id, 0)
                    blf.enable(font_id, blf.WORD_WRAP)
                    blf.draw(font_id, "press 'X' 'Y' 'Z' to align the model\nto the spline\npress 'Esc' to valid")
                    blf.disable(font_id, blf.ROTATION)
                    blf.disable(font_id, blf.WORD_WRAP)
                font_id = 0
                if os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf') and os.path.exists(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf')):
                    font_id = blf.load(os.path.join(os.path.dirname(__file__), 'assets', 'Digitalt.ttf'))
                if font_id == -1:
                    print("Couldn't load font!")
                else:
                    x_961FB, y_961FB = (float(int(self.sna_pos_x / 2.0) - 150.0), int(self.sna_pos_y - 150.0))
                    blf.position(font_id, x_961FB, y_961FB, 0)
                    if bpy.app.version >= (3, 4, 0):
                        blf.size(font_id, 30.0)
                    else:
                        blf.size(font_id, 30.0, 72)
                    clr = (0.48587551712989807, 0.7200000286102295, 0.12308082729578018, 1.0)
                    blf.color(font_id, clr[0], clr[1], clr[2], clr[3])
                    if 250:
                        blf.enable(font_id, blf.WORD_WRAP)
                        blf.word_wrap(font_id, 250)
                    if False:
                        blf.enable(font_id, blf.ROTATION)
                        blf.rotation(font_id, 0)
                    blf.enable(font_id, blf.WORD_WRAP)
                    blf.draw(font_id, 'Align Car Rotation')
                    blf.disable(font_id, blf.ROTATION)
                    blf.disable(font_id, blf.WORD_WRAP)
            except Exception as error:
                print(error)

    def execute(self, context):
        global _C9DCF_running
        _C9DCF_running = False
        context.window.cursor_set("DEFAULT")
        bpy.types.SpaceView3D.draw_handler_remove(self._handle, 'WINDOW')
        bpy.context.scene.sna_cr_modal_activ = False
        exec('bpy.context.object.sna_cr_carrig_curve.data.bevel_depth = 0.0')
        exec("bpy.context.scene.transform_orientation_slots[0].type = carrig_setup['sna_name_tmp'] ")
        for area in context.screen.areas:
            area.tag_redraw()
        return {"FINISHED"}

    def modal(self, context, event):
        global _C9DCF_running
        if not context.area or not _C9DCF_running:
            self.execute(context)
            return {'CANCELLED'}
        self.save_event(event)
        context.area.tag_redraw()
        context.window.cursor_set('HAND')
        try:
            ob = bpy.context.view_layer.objects.active
            direction = ('YZ' if (event.type == 'Z' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else ('XY' if (event.type == 'Y' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else ('ZX' if (event.type == 'X' and event.value == 'PRESS' and event.alt == False and event.shift == False and event.ctrl == False) else 'None')))
            from math import pi

            def bone_world_matrix(rig, bone):
                return rig.matrix_world@bone.matrix
            #décompose matrice world:
            orig_loc, orig_rot, orig_scale = ob.matrix_world.decompose()
            local_axis_global_coords = Vector((0.0,0.0,0.0))
            #Marice translation:
            orig_loc_mat = Matrix.Translation(orig_loc)
            #Marice rotation:
            orig_rot_mat = orig_rot.to_matrix().to_4x4()
            #Marice scale:
            orig_scale_mat = Matrix.Scale(orig_scale[0],4,(1,0,0)) * Matrix.Scale(orig_scale[1],4,(0,1,0)) * Matrix.Scale(orig_scale[2],4,(0,0,1))
            normalize_matrix_world = ob.matrix_world.normalized()
            if direction == 'YZ':
                local_axis_global_coords = [row[2] for row in normalize_matrix_world[:3]]
            elif direction == 'ZX':
                local_axis_global_coords = [row[0] for row in normalize_matrix_world[:3]]
            elif direction == 'XY':
                local_axis_global_coords = [row[1] for row in normalize_matrix_world[:3]]
            rot_mat = Matrix.Rotation(pi/2, 4, local_axis_global_coords)
            ob.matrix_world = orig_loc_mat @ rot_mat @ orig_rot_mat @ orig_scale_mat
        except Exception as error:
            print(error)
        if event.type in ['RIGHTMOUSE', 'ESC']:
            self.execute(context)
            return {'CANCELLED'}
        return {'RUNNING_MODAL'}

    def invoke(self, context, event):
        global _C9DCF_running
        if _C9DCF_running:
            _C9DCF_running = False
            return {'FINISHED'}
        else:
            self.save_event(event)
            self.start_pos = (event.mouse_x, event.mouse_y)
            exec("carrig_setup['sna_name_tmp'] = bpy.context.scene.transform_orientation_slots[0].type")
            exec('bpy.context.scene.cursor.location = bpy.context.object.matrix_world.to_translation()')
            bpy.ops.view3d.view_center_cursor('INVOKE_DEFAULT', )
            bpy.context.scene.sna_cr_modal_activ = True
            self.report({'INFO'}, message='Align Car Body To The Path !')
            areas = bpy.context.workspace.screens[0].areas
            for area in areas:
                for space in area.spaces:
                    if space.type == 'VIEW_3D':
                        space.show_gizmo_object_translate = True
                        space.show_gizmo = True
                        bpy.ops.wm.tool_set_by_id(name="builtin.move")
                        bpy.context.scene.transform_orientation_slots[0].type = 'LOCAL'
                        #space.region_3d.view_camera_zoom -= 20
            ########################################################
            #region_3d.view_camera_zoom += foo
            #bpy.data.scenes['Scene'].transform_orientation_slots[0].type
            #bpy.ops.view3d.view_selected(use_all_regions=False)
            #######################################################
            #v3d = [x for x in bpy.context.screen.areas if x.type == 'VIEW_3D']
            #if v3d:
            #    # you need to decide what to do if there are more than one 3D Views present
            #    # you could either set the orientation on the first one, or on a specific one
            #    # to set it on all views:
            #    for v in v3d:
            #        v.spaces[0].transform_orientation = 'LOCAL'
            posx = None
            posy = None
            for area in bpy.context.screen.areas:
                if area.type == 'VIEW_3D':
                    posx = int(area.width * 1)
                    posy = int(area.height * 1)
            self.sna_pos_x = posx
            self.sna_pos_y = posy
            exec('bpy.context.object.sna_cr_carrig_curve.data.bevel_depth = .1')
            args = (context,)
            self._handle = bpy.types.SpaceView3D.draw_handler_add(self.draw_callback_px, args, 'WINDOW', 'POST_PIXEL')
            context.window_manager.modal_handler_add(self)
            _C9DCF_running = True
            return {'RUNNING_MODAL'}


class SNA_OT_Cr_Op_Toggle_90495(bpy.types.Operator):
    bl_idname = "sna.cr_op_toggle_90495"
    bl_label = "CR_OP_Toggle"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        if bpy.context.view_layer.objects.active.sna_cr_bool:
            pass
        else:
            collection_name_0_702cc = sna_get_outliner_collection_C555D_702CC(bpy.context.view_layer.objects.active)
            carrig_setup['sna_collection_name_tmp'] = collection_name_0_702cc
            areas = bpy.context.workspace.screens[0].areas
            for area in areas:
                for space in area.spaces:
                    if space.type == 'VIEW_3D':
                        space.show_gizmo_object_translate = True
                        space.show_gizmo = True
                        bpy.ops.wm.tool_set_by_id(name="builtin.move")
                        bpy.context.scene.transform_orientation_slots[0].type = 'LOCAL'
                        #space.region_3d.view_camera_zoom -= 20
            ########################################################
            #region_3d.view_camera_zoom += foo
            #bpy.data.scenes['Scene'].transform_orientation_slots[0].type
            #bpy.ops.view3d.view_selected(use_all_regions=False)
            #######################################################
            #v3d = [x for x in bpy.context.screen.areas if x.type == 'VIEW_3D']
            #if v3d:
            #    # you need to decide what to do if there are more than one 3D Views present
            #    # you could either set the orientation on the first one, or on a specific one
            #    # to set it on all views:
            #    for v in v3d:
            #        v.spaces[0].transform_orientation = 'LOCAL'
            bpy.context.view_layer.objects.active.sna_cr_id_collec.clear()
            before_data = list(bpy.data.objects)
            bpy.ops.wm.append(directory=os.path.join(os.path.dirname(__file__), 'assets', 'rigicar_assets_2.1.3.blend') + r'\Object', filename='RigiCar', link=False)
            new_data = list(filter(lambda d: not d in before_data, list(bpy.data.objects)))
            appended_37C95 = None if not new_data else new_data[0]
            carrig_setup['sna_name_tmp'] = bpy.context.view_layer.objects.active.name
            for i_3653B in range(len(bpy.context.view_layer.objects.selected)):
                if bpy.context.view_layer.objects.selected[i_3653B].type == 'ARMATURE':
                    carrig_setup['sna_obj_tmp'] = bpy.context.view_layer.objects.selected[i_3653B]
            out = None
            out = f'{random.randrange(16**3):x}'
            carrig_setup['sna_rig_name_tmp'] = 'RigiCar_' + carrig_setup['sna_name_tmp'] + '_' + out
            carrig_setup['sna_obj_tmp'].name = carrig_setup['sna_rig_name_tmp']
            item_08247 = bpy.context.view_layer.objects.active.sna_cr_id_collec.add()
            item_08247.rig = bpy.data.objects[carrig_setup['sna_rig_name_tmp']]
            sna_move_outliner_collection_object_A90B9_4CCDB(item_08247.rig, 'RigiCar_Collection')
            car = bpy.context.object
            bpy.ops.object.select_all(action='DESELECT')
            for o in bpy.data.objects:
                for shape in ['rc_brake_bone_shape','rc_frame_w_bone_shape','rc_steering_w_bone_shape','rc_wheel_bone_shape','rc_essieu_w_bone_shape','rc_transmission_bone_shape']:
                    print('shape=',shape,' o name=',o.name)
                    if shape in o.name:
                        try:
                            o.select_set(True)
                            break
                        except:
                            print(o.name,' is not in view layer')
            bpy.ops.object.delete(use_global=False)
            car.select_set(True)
            bpy.context.view_layer.objects.active = car
            out = None
            out = f'{random.randrange(16**3):x}'
            carrig_setup['sna_curve_name_tmp'] = 'RigiCar_Path_Curve_' + carrig_setup['sna_name_tmp'] + '_' + out
            bpy.data.objects['RigiCar_Path_Curve'].name = carrig_setup['sna_curve_name_tmp']
            bpy.context.view_layer.objects.active.sna_cr_carrig_curve = bpy.data.objects[carrig_setup['sna_curve_name_tmp']]
            bpy.context.view_layer.objects.active.sna_cr_id_collec[0].path_curve = bpy.data.objects[carrig_setup['sna_curve_name_tmp']]
            sna_move_outliner_collection_object_A90B9_E6A72(bpy.context.view_layer.objects.active.sna_cr_id_collec[0].path_curve, carrig_setup['sna_collection_name_tmp'])
            bpy.ops.sna.cr_op_fiil_spring_list_afd4a('INVOKE_DEFAULT', sna_rig_name=carrig_setup['sna_rig_name_tmp'])
            print(str(carrig_setup['sna_cr_bool_tmp']))
            if (not carrig_setup['sna_cr_bool_tmp']):
                bpy.ops.sna.cr_mop_algin_car_c9dcf('INVOKE_DEFAULT', sna_pos_x=0, sna_pos_y=0)
        car = bpy.context.object
        if car.sna_cr_bool: #### True -> False (deactiver)
            bpy.ops.object.visual_transform_apply()
            bpy.ops.object.select_all(action='DESELECT')
            ### clear parent et replace la voiture globalement au mme endroit
            car_mat = car.matrix_world
            car.parent = None    
            car.matrix_world = car_mat
            try:
                wheel_mat = car.sna_cr_wheel_avg.matrix_world
                car.sna_cr_wheel_avg.parent = None
                car.sna_cr_wheel_avg.matrix_world = wheel_mat
            except:
                print('no wheel')
            car.sna_cr_wheel_avg = None
            bpy.ops.object.select_all(action='DESELECT') ### car select la voiture automatiquement qd wheel_avg pointe sur None !!!
            car.sna_cr_carrig_curve = None
            #### clear carrig 
            car_id = car.sna_cr_id_collec
            try:
                car_id[0].rig.select_set(True)
            except:
                print('no car_rig')
            try:        
                car_id[0].path_curve.select_set(True)
            except:
                print('no path_curve')
            try:
                car_id[0].wheel_avd.hide_select = False
                car_id[0].wheel_avd.select_set(True)
                car_id[0].wheel_ard.hide_select = False
                car_id[0].wheel_ard.select_set(True)
                car_id[0].wheel_arg.hide_select = False
                car_id[0].wheel_arg.select_set(True)
            except:
                print('no wheel')
            bpy.ops.object.delete()
            car.select_set(True)
            bpy.context.view_layer.objects.active = car
            car.sna_cr_chassis_large = 1.0
            car.sna_cr_chassis_long = 1.0
            #car.sna_cr_chassis_suspension = 1.0
            car.sna_cr_bool = False
            bpy.ops.outliner.orphans_purge(do_recursive=True)
        else: #### False -> True (activer)
            ############## problem si animation keys sur les roues #########################
            try:
                fc = car.animation_data.action.fcurves
                for f in fc:
                    fc.remove(f)
            except:
                print("no animation data")
            bpy.context.scene.tool_settings.use_keyframe_insert_auto = False
            #################################################################################
            car['old_speed'] = 0.0
            car_id = car.sna_cr_id_collec
            ### identifie la curve path du rig ###
            carrig = car_id[0].rig
            carrig.data.override_create(remap_local_usages=True)
            carrig_bones = carrig.pose.bones
            carrig_main_bone = carrig_bones[0]
            car.sna_cr_carrig_curve = car_id[0].path_curve
            ### localise le rig à l'emplacement de la voiture
            car_id[0].path_curve.location = car.location
            #### voiture parent du bone body.damped
            car.location = (0,0,0)
            car.parent = carrig
            car.parent_type = 'BONE'
            car.parent_bone = 'body_bank'
            bpy.ops.object.select_all(action='DESELECT')
            car.select_set(True)
            bpy.context.view_layer.objects.active = car
            bpy.ops.object.rotation_clear(clear_delta=False)
            ### remove bone shape appened
            #bpy.data.objects.remove(bpy.data.objects['Carrig_main_shape'])
            car.sna_cr_path_distance = 0.0
            car.sna_cr_instant_speed = 0.0
            car.sna_cr_ground_obj = None
            car.sna_cr_sb_global_spring = False
            car.sna_cr_view_rig = False
            car.sna_cr_drift = 0
            car.sna_cr_torque = 0
            car.sna_cr_counter_steering = 0
            car.sna_cr_jump_fr = 0
            car.sna_cr_jump_bk = 0
            car.sna_cr_transmission_mode = 'TRACTION'
            car.sna_cr_bool = True
            #bpy.data.objects['Carrig_Voiture'].pose.bones['main_drive'].constraints['Follow Path'].use_curve_follow
            #bpy.ops.ptcache.bake(bake=True)
        if bpy.context.view_layer.objects.active.sna_cr_bool:
            sna_fu_add_rigicar_col_object_1E008(bpy.context.scene.sna_cr_rigicar_objects_col, bpy.context.view_layer.objects.active)
        else:
            bpy.context.view_layer.objects.active.sna_cr_id_collec.clear()
            sna_fu_remove_rigicar_col_object_21A8E(bpy.context.scene.sna_cr_rigicar_objects_col, bpy.context.view_layer.objects.active)
            bpy.ops.outliner.orphans_purge()
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


@persistent
def render_init_handler_D36F0(dummy):
    bpy.context.scene.frame_current = bpy.data.scenes['Scene'].frame_start


def sna_fu_remove_rigicar_col_object_21A8E(Rigicar_Col, object):
    for i_E8BDB in range(len(Rigicar_Col)):
        if (Rigicar_Col[i_E8BDB].rigicar_object == object):
            for i_DED42 in range(len(Rigicar_Col)):
                if Rigicar_Col[i_DED42] == Rigicar_Col[i_E8BDB]:
                    Rigicar_Col.remove(i_DED42)
                    break


def sna_cr_fc_update_car_4E413():
    for i_6B66F in range(len(bpy.context.scene.sna_cr_rigicar_objects_col)):
        if sna_fu_test_is_in_viewlayer_FD19C(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object):
            from math import sqrt, degrees, dist
            import numpy
            distance = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_path_distance
            path_curve = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_carrig_curve
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            acc = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig['CarRig_Acc']
            speed = None
            offset_factor = None
            acceleration = None
            #import bl_math
            #from math import sqrt, degrees, dist
            #from mathutils import *
            #import numpy
            #from numpy import dot

            def has_keyframe(ob, attr):
                anim = ob.animation_data
                if anim is not None and anim.action is not None:
                    for fcu in anim.action.fcurves:
                        if fcu.data_path == attr:
                            return len(fcu.keyframe_points) > 0
                return False
            bpy.context.view_layer.update()
            curve_len = path_curve.data.splines[0].calc_length()
            f =  distance / curve_len
            acceleration = 0.0
            if f <= 1.0:
                offset_factor = f
            else:
                offset_factor = 1.0
                car.sna_cr_path_distance = curve_len
            if has_keyframe(car, 'sna_cr_path_distance'):
                frame = bpy.context.scene.frame_current
                bpy.context.view_layer.update()
                if frame > bpy.context.scene.frame_start:       
                    f = car.animation_data.action.fcurves.find('sna_cr_path_distance')
                    speed = (car.sna_cr_path_distance - f.evaluate(frame-1)) * bpy.context.scene.render.fps * 3.6
                    if frame > bpy.context.scene.frame_start+1:
                        speed_before = (f.evaluate(frame - 1) - f.evaluate(frame-2)) * bpy.context.scene.render.fps * 3.6
                    else:
                        speed_before = 0.0#speed
                else:
                    speed = 0.0
                    speed_before = 0.0
                    acc = 0.0      
                diff = (speed - speed_before) * .1
                smooth_duration = car.sna_cr_interpol_duration
                if frame == bpy.context.scene.frame_start:
                    car.sna_cr_frame_interpol = -1
                bpy.context.view_layer.update()
                if speed == 0:
                    if speed_before == 0: ### voiture en arret
                        car.sna_debug_state = 'STOP'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                        if car.sna_cr_frame_interpol > 0: ### amortie de l'arret
                            if frame > car.sna_cr_frame_interpol+smooth_duration: #### fin amortie arret
                                car.sna_cr_frame_interpol = -1
                                acceleration = 0.0
                                car.sna_debug_state = 'STOP-INTERPOL-end'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                            else: #### en cours d'amortie d'arret
                                acceleration = acc * bl_math.smoothstep(car.sna_cr_frame_interpol+smooth_duration,car.sna_cr_frame_interpol-1,frame) 
                                car.sna_debug_state = 'STOP-INTERPOL'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                    else: ### première clé de stop
                        car.sna_cr_frame_interpol = frame
                        car.sna_cr_interpol_duration = max(1,int(acc * 6)) * car.sna_cr_interpol_duration_factor
                        smooth_duration = car.sna_cr_interpol_duration
                        acceleration = acc * bl_math.smoothstep(car.sna_cr_frame_interpol+smooth_duration,car.sna_cr_frame_interpol-1,frame) 
                        car.sna_debug_state = 'STOP-INTERPOL-start'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                else:
                    if speed_before == 0: ### voiture démarre
                        car.sna_cr_frame_interpol = frame
                        car.sna_cr_interpol_duration = max(1,int( abs(speed) )) * car.sna_cr_interpol_duration_factor
                        smooth_duration = car.sna_cr_interpol_duration
                        acceleration = diff * bl_math.smoothstep(car.sna_cr_frame_interpol-1,car.sna_cr_frame_interpol+smooth_duration,frame) 
                        car.sna_debug_state = 'RUN-INTERPOL-start' #+ '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                    else:
                        if car.sna_cr_frame_interpol > 0: ### fin amortie de depart
                            if frame > car.sna_cr_frame_interpol+smooth_duration: #### fin amortie de depart
                                car.sna_cr_frame_interpol = -1
                                acceleration = diff
                                car.sna_debug_state = 'RUN-INTERPOL-end'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                            else: ### en cours d'amortie de depart
                                acceleration = diff * bl_math.smoothstep(car.sna_cr_frame_interpol-1,car.sna_cr_frame_interpol+smooth_duration,frame) 
                                car.sna_debug_state = 'RUN-INTERPOL'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
                        else:
                            acceleration = diff
                            car.sna_debug_state = 'RUN'# + '\nspeed = ' + str(speed) + '\nspeed_before = ' + str(speed_before)
            else:
                speed = 0.0
            ########################## NEW ACC/ DE-ACC ###################
            #carrig.pose.bones['AVG.steer_sp_rest_pose'].locatoin.y = 
            list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig.pose.bones['main_drive'].constraints['Follow Path'].offset_factor = offset_factor
            bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_instant_speed = speed
            list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig['CarRig_Speed'] = speed
            list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig['CarRig_Acc'] = acceleration
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            wavd = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].wheel_avd
            ward = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].wheel_ard
            warg = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].wheel_arg
            wheel_radius = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_wheel_radius
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            #from mathutils import Vector,Matrix,Euler
            #from math import sqrt, degrees

            def norm_vect(vect):
                return sqrt(vect[0]*vect[0] + vect[1]*vect[1] + vect[2]*vect[2])

            def vect(A,B):
                return (B[0]-A[0], B[1]-A[1], B[2]-A[2])

            def rot_wheel(bone, angle):
                # local axes of the bone
                x, y, z = bone.matrix.to_3x3().col
                # rotation matrix 30 degrees around local x axis thru head
                R = (Matrix.Translation(bone.head) @
                     Matrix.Rotation(angle, 4, y) @
                     Matrix.Translation(-bone.head)
                    )
                bone.matrix = R @ bone.matrix
                #bone.transform(R)

            def rot_wheel_bone(bone, angle):
                bone.rotation_axis_angle[0] = angle
            bpy.context.view_layer.update()
            f_brake = 1 - car.sna_cr_brake_fr
            b_brake = 1 - car.sna_cr_brake_bk
            try:
                wavg = car.sna_cr_wheel_avg
                if bpy.context.scene.frame_current == bpy.context.scene.frame_start:
                    wavd["previous_loc"] = (wavd.matrix_world.translation.x,
                                            wavd.matrix_world.translation.y,
                                            wavd.matrix_world.translation.z)
                    wavg["previous_loc"] = (wavg.matrix_world.translation.x,
                                            wavg.matrix_world.translation.y,
                                            wavg.matrix_world.translation.z)
                    ward["previous_loc"] = (ward.matrix_world.translation.x,
                                            ward.matrix_world.translation.y,
                                            ward.matrix_world.translation.z)
                    warg["previous_loc"] = (warg.matrix_world.translation.x,
                                            warg.matrix_world.translation.y,
                                            warg.matrix_world.translation.z)
                    wavd['previous_angle'] = 0.0
                    wavg['previous_angle'] = 0.0
                    ward['previous_angle'] = 0.0
                    warg['previous_angle'] = 0.0
                    rot_wheel_bone(carrig.pose.bones["AVD.steer.W"], 0.0)
                    rot_wheel_bone(carrig.pose.bones["AVG.steer.W"], 0.0)
                    rot_wheel_bone(carrig.pose.bones["ARD.W"], 0.0)
                    rot_wheel_bone(carrig.pose.bones["ARG.W"], 0.0)
                else:
                    if carrig['CarRig_Speed'] > 0:
                        loc = wavd.matrix_world.translation
                        d_avd = norm_vect(vect(wavd["previous_loc"], (loc.x,loc.y,loc.z)))            
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'TRACTION' or car.sna_cr_transmission_mode == '4X4':
                            angle += car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["AVD.steer.W"], wavd["previous_angle"] - angle*f_brake)
                        wavd["previous_loc"] = (loc.x,loc.y,loc.z)
                        wavd["previous_angle"] -= angle*f_brake
                        loc = wavg.matrix_world.translation
                        d_avg = norm_vect(vect(wavg["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'TRACTION' or car.sna_cr_transmission_mode == '4X4':
                            angle += car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["AVG.steer.W"], wavg["previous_angle"] + angle*f_brake)
                        wavg["previous_loc"] = (loc.x,loc.y,loc.z)
                        wavg["previous_angle"] += angle*f_brake
                        loc = ward.matrix_world.translation
                        d_ard = norm_vect(vect(ward["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'PROPULSION' or car.sna_cr_transmission_mode == '4X4':
                            angle += car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["ARD.W"], ward["previous_angle"] - angle*b_brake)
                        ward["previous_loc"] = (loc.x,loc.y,loc.z)
                        ward["previous_angle"] -= angle*b_brake
                        loc = warg.matrix_world.translation
                        d_arg = norm_vect(vect(warg["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'PROPULSION' or car.sna_cr_transmission_mode == '4X4':
                            angle += car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["ARG.W"], warg["previous_angle"] + angle*b_brake)
                        warg["previous_loc"] = (loc.x,loc.y,loc.z)
                        warg["previous_angle"] += angle*b_brake
                    else:
                        loc = wavd.matrix_world.translation
                        d_avd = norm_vect(vect(wavd["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'TRACTION' or car.sna_cr_transmission_mode == '4X4':
                            angle -= car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["AVD.steer.W"], wavd["previous_angle"] + angle*f_brake)
                        wavd["previous_loc"] = (loc.x,loc.y,loc.z)
                        wavd["previous_angle"] += angle*f_brake
                        loc = wavg.matrix_world.translation
                        d_avg = norm_vect(vect(wavg["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'TRACTION' or car.sna_cr_transmission_mode == '4X4':
                            angle -= car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["AVG.steer.W"], wavg["previous_angle"] - angle*f_brake)
                        wavg["previous_loc"] = (loc.x,loc.y,loc.z)
                        wavg["previous_angle"] -= angle*f_brake
                        loc = ward.matrix_world.translation
                        d_ard = norm_vect(vect(ward["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'PROPULSION' or car.sna_cr_transmission_mode == '4X4':
                            angle -= car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["ARD.W"], ward["previous_angle"] + angle*b_brake)
                        ward["previous_loc"] = (loc.x,loc.y,loc.z)
                        ward["previous_angle"] += angle*b_brake
                        loc = warg.matrix_world.translation
                        d_arg = norm_vect(vect(warg["previous_loc"], (loc.x,loc.y,loc.z)))
                        angle = d_avd / wheel_radius
                        if car.sna_cr_transmission_mode == 'PROPULSION' or car.sna_cr_transmission_mode == '4X4':
                            angle -= car.sna_cr_torque
                        rot_wheel_bone(carrig.pose.bones["ARG.W"], warg["previous_angle"] - angle*b_brake)
                        warg["previous_loc"] = (loc.x,loc.y,loc.z)
                        warg["previous_angle"] -= angle*b_brake        
            except:
                print('no wheel')
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            bpy.context.view_layer.update()
            path = car.sna_cr_carrig_curve
            curve_len = path.data.splines[0].calc_length()
            carrig = car.sna_cr_id_collec[0].rig
            carrig["CarRig_path_len"] = path.data.splines[0].calc_length()
            main_offset = carrig.pose.bones['main_drive'].constraints["Follow Path"].offset_factor
            scale = carrig.pose.bones['main_drive_scale'].scale.x
            ##### .1*45.50459289550781*0.4395 = 1.9999268577575686 donc 2 !
            steer_offset = main_offset+scale*2/curve_len
            carrig.pose.bones['steering'].constraints["Follow Path"].offset_factor = steer_offset
            bpy.context.view_layer.update()
            carrig.pose.bones['main_target'].constraints["Follow Path"].offset_factor = main_offset*.35 + steer_offset*.65
            bpy.context.view_layer.update()
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            #import math
            ##### calcul distance entre ref1 et ref2
            ref1 = carrig.pose.bones['steer.ref1']
            ref2 = carrig.pose.bones['steer.ref2']
            loc1 = (carrig.matrix_world @ ref1.matrix).to_translation()
            loc2 = (carrig.matrix_world @ ref2.matrix).to_translation()
            banker = dist(loc1,loc2)
            #### calcul entraxe essieu avant
            avd = carrig.pose.bones['AVD']
            avg = carrig.pose.bones['AVG']
            loc1 = (carrig.matrix_world @ avd.matrix).to_translation()
            loc2 = (carrig.matrix_world @ avg.matrix).to_translation()
            ecart = dist(loc1,loc2)
            #### scale chassi en longueur
            scale = carrig.pose.bones['main_drive_scale'].scale.z
            factor = carrig["CarRig_Bank_factor"]
            speed = carrig["CarRig_Speed"]
            carrig.pose.bones['body_bank'].rotation_axis_angle[0] = (banker-ecart/2)*factor*speed*.1
            bpy.context.view_layer.update() 
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            drift_bone = carrig.pose.bones['drift']
            drift_bone.location.z = - car.sna_cr_drift
            drift_bank = abs(car.sna_cr_drift*.001)
            carrig['CarRig_Drift'] = car.sna_cr_drift
            bpy.context.view_layer.update() 
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            AVG_steer_bone = carrig.pose.bones['AVG.W.steer.over']
            AVD_steer_bone = carrig.pose.bones['AVD.W.steer.over']
            AVG_steer_bone.rotation_axis_angle[0] = car.sna_cr_counter_steering
            AVD_steer_bone.rotation_axis_angle[0] = car.sna_cr_counter_steering
            bpy.context.view_layer.update()
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object

            def vect(A,B):
                return (B[0]-A[0], B[1]-A[1], B[2]-A[2])

            def get_bone_pose_matrix_cleaned(bone):
                offset_m4 = (Matrix.Translation(bone.location) @ Quaternion(bone.rotation_quaternion).to_matrix().to_4x4())
                return bone.matrix @ offset_m4.inverted()
            start_bone = carrig.pose.bones['main_drive']
            end_bone = carrig.pose.bones['steering']
            mid_bone = carrig.pose.bones['main_target']
            m_A = get_bone_pose_matrix_cleaned(start_bone)
            pt_A = m_A.to_translation()
            m_B = get_bone_pose_matrix_cleaned(end_bone)
            pt_B = m_B.to_translation()
            m_C = get_bone_pose_matrix_cleaned(mid_bone)
            pt_C = m_C.to_translation()
            vec_AB = Vector(vect(pt_A,pt_B))
            vec_AC = Vector(vect(pt_A,pt_C))
            vec_cross = vec_AB.cross(vec_AC)
            curvature = vec_cross.dot(Vector((0.0,0.0,1.0)))
            carrig["RigCar_Curvature"] = curvature# * 10
            print( 'curvature=',curvature)
            bpy.context.view_layer.update()
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            jump_fr_bone = carrig.pose.bones['axis_fr']
            jump_bk_bone = carrig.pose.bones['axis_bk']
            #bank_bone = carrig.pose.bones['body_bank']
            jump_fr_bone.location.z = - car.sna_cr_jump_fr*2
            jump_bk_bone.location.z = - car.sna_cr_jump_bk*2
            bpy.context.view_layer.update()
            carrig = list(bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object.sna_cr_id_collec)[0].rig
            car = bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F].rigicar_object
            #from mathutils import *
            #import math
            #import numpy
            #from numpy import dot
            #from math import sqrt

            def lerp_vec(vec_a, vec_b, t):                        
                return vec_a*t + vec_b*(1-t)

            def get_bone_pose_matrix_cleaned(bone):
                offset_m4 = (Matrix.Translation(bone.location) @ Quaternion(bone.rotation_quaternion).to_matrix().to_4x4())
                return bone.matrix @ offset_m4.inverted()

            def set_bone_world_position(bone, arm, worldPosition):
                return get_bone_pose_matrix_cleaned(bone).inverted() @ arm.matrix_world.inverted() @ worldPosition
            s = bpy.context.scene
            bpy.context.view_layer.update()
            #bpy.context.evaluated_depsgraph_get()
            if car.sna_cr_sb_global_spring:
                for sp_bone_item in carrig.sna_cr_sb_spring_bones_col:
                    ###### type de spring determine les valeurs dynamiques:    
                    stiffness = car.sna_cr_sb_spring_stiffness
                    damp = car.sna_cr_sb_spring_damp
                    global_influence = car.sna_cr_sb_spring_global_influence
                    ##############################################################
                    ###### select bones utiles en fonction du nom du bone string:
                    sp_rest_pose = sp_bone_item.bone_spring_name + '_sp_rest_pose'
                    sp_to_track_to = sp_bone_item.bone_spring_name + '_sp_to_track_to'
                    bone_target_spring = carrig.pose.bones[sp_rest_pose]     
                    bone_track_spring = carrig.pose.bones[sp_to_track_to]
                    ############################################################
                    if s.frame_current == s.frame_start:
                        ############## mettre à zéro en début de timeline
                        sp_bone_item.speed_spring = Vector((0.0,0.0,0.0))          
                        bone_target_spring_world_matrix = carrig.matrix_world @ bone_target_spring.matrix
                        bone_target_spring_loc, rot, scale = bone_target_spring_world_matrix.decompose()
                        bone_track_spring.location = set_bone_world_position(bone_track_spring, carrig, bone_target_spring_loc)
                        bpy.context.view_layer.update()  
                    else:
                        if global_influence > 0.0:
                            bone_target_spring_world_matrix = carrig.matrix_world @ bone_target_spring.matrix
                            bone_target_spring_loc, rot, scale = bone_target_spring_world_matrix.decompose()
                            bone_track_spring_world_matrix = carrig.matrix_world @ bone_track_spring.matrix
                            bone_track_spring_loc, rot, scale = bone_track_spring_world_matrix.decompose()     
                            ################################################################# SPRING ########
                            # start compute spring
                            base_pos_dir = Vector((0.0,0.0,0.0)) 
                            # add spring
                            base_pos_dir -= (bone_track_spring_loc - bone_target_spring_loc)
                            # add velocity
                            sp_bone_item.speed_spring += base_pos_dir * stiffness
                            sp_bone_item.speed_spring *= damp
                            if car.sna_cr_sb_lock_z_axis:      
                                sp_bone_item.speed_spring.x = 0
                                sp_bone_item.speed_spring.y = 0
                            # spring fx:
                            bone_track_spring_loc += sp_bone_item.speed_spring
                            if carrig.sna_cr_sb_lock_z_axis:
                                bone_track_spring_loc.x = bone_target_spring_loc.x
                                bone_track_spring_loc.y = bone_target_spring_loc.y
                            bone_track_spring_loc = lerp_vec(bone_track_spring_loc, bone_target_spring_loc, global_influence)
                            bone_track_spring.location = set_bone_world_position(bone_track_spring, carrig, bone_track_spring_loc)
            bpy.context.view_layer.update() 
            if bpy.context and bpy.context.screen:
                for a in bpy.context.screen.areas:
                    a.tag_redraw()
        else:
            for i_51A70 in range(len(bpy.context.scene.sna_cr_rigicar_objects_col)):
                if bpy.context.scene.sna_cr_rigicar_objects_col[i_51A70] == bpy.context.scene.sna_cr_rigicar_objects_col[i_6B66F]:
                    bpy.context.scene.sna_cr_rigicar_objects_col.remove(i_51A70)
                    break


def sna_fu_test_is_in_viewlayer_FD19C(Object):
    ob = Object
    out = None
    out = ob in bpy.context.view_layer.objects[:]
    return out


def sna_fu_add_rigicar_col_object_1E008(Rigicar_col, object):
    item_E17FE = Rigicar_col.add()
    item_E17FE.rigicar_object = object


class SNA_OT_Cr_Op_Paste_Parametters_52B4D(bpy.types.Operator):
    bl_idname = "sna.cr_op_paste_parametters_52b4d"
    bl_label = "CR_OP_Paste_parametters"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    def sna_all_cars_enum_items(self, context):
        return [("No Items", "No Items", "No generate enum items node found to create items!", "ERROR", 0)]
    sna_all_cars: bpy.props.EnumProperty(name='all_cars', description='', items=[('Selected RigiCar', 'Selected RigiCar', '', 0, 0), ('All RigiCars', 'All RigiCars', '', 0, 1)])

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        all = self.sna_all_cars
        params = carrig_setup['sna_cr_param_buffer']
        car = bpy.context.object
        if all == 'Selected RigiCar':
            car.sna_cr_chassis_large = params[0]
            car.sna_cr_chassis_long = params[1]
            car.sna_cr_id_collec[0].rig['CarRig_Bank_factor'] = params[2]
            car.sna_cr_id_collec[0].rig['CarRig_Acc_Factor'] = params[3]
            car.sna_cr_interpol_duration_factor = params[4]
            car.sna_cr_sb_global_spring = params[5]
            car.sna_cr_sb_lock_z_axis = params[6]
            car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_stiffness = params[7]
            car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_damp = params[8]
            car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_global_influence = params[9]
        else:
            for ob in bpy.data.objects:
                if ob.sna_cr_bool:
                    ob.sna_cr_chassis_large = params[0]
                    ob.sna_cr_chassis_long = params[1]
                    ob.sna_cr_id_collec[0].rig['CarRig_Bank_factor'] = params[2]
                    ob.sna_cr_id_collec[0].rig['CarRig_Acc_Factor'] = params[3]
                    ob.sna_cr_interpol_duration_factor = params[4]
                    ob.sna_cr_sb_global_spring = params[5]
                    ob.sna_cr_sb_lock_z_axis = params[6]
                    ob.sna_cr_id_collec[0].rig.sna_cr_sb_spring_stiffness = params[7]
                    ob.sna_cr_id_collec[0].rig.sna_cr_sb_spring_damp = params[8]
                    ob.sna_cr_id_collec[0].rig.sna_cr_sb_spring_global_influence = params[9]
        return {"FINISHED"}

    def draw(self, context):
        layout = self.layout
        layout.label(text='', icon_value=1)
        layout.prop(self, 'sna_all_cars', text=self.sna_all_cars, icon_value=0, emboss=True, expand=True, toggle=True)

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self, width=300)


class SNA_OT_Cr_Op_Copy_Parametters_18D32(bpy.types.Operator):
    bl_idname = "sna.cr_op_copy_parametters_18d32"
    bl_label = "CR_OP_Copy_parametters"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        params = []
        car = bpy.context.object
        params.append(car.sna_cr_chassis_large)
        params.append(car.sna_cr_chassis_long)
        params.append(car.sna_cr_id_collec[0].rig['CarRig_Bank_factor'])
        params.append(car.sna_cr_id_collec[0].rig['CarRig_Acc_Factor'])
        params.append(car.sna_cr_interpol_duration_factor)
        params.append(car.sna_cr_sb_global_spring)
        if car.sna_cr_sb_global_spring:
            params.append(car.sna_cr_sb_lock_z_axis)
            params.append(car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_stiffness)
            params.append(car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_damp)
            params.append(car.sna_cr_id_collec[0].rig.sna_cr_sb_spring_global_influence)
        else:
            params.append(True)
            params.append(.5)
            params.append(.7)
            params.append(1.0)
        carrig_setup['sna_cr_param_buffer'] = params
        return {"FINISHED"}

    def invoke(self, context, event):
        return self.execute(context)


class SNA_OT_Cr_Op_Update_Rigicar_Model_94895(bpy.types.Operator):
    bl_idname = "sna.cr_op_update_rigicar_model_94895"
    bl_label = "CR_OP_update_rigicar_model"
    bl_description = ""
    bl_options = {"REGISTER", "UNDO"}

    @classmethod
    def poll(cls, context):
        if bpy.app.version >= (3, 0, 0) and False:
            cls.poll_message_set()
        return not False

    def execute(self, context):
        carrig_setup['sna_object_tmp'] = bpy.context.view_layer.objects.active
        for i_5F507 in range(len(bpy.data.objects)):
            if bpy.data.objects[i_5F507].sna_cr_bool:
                for i_C7D23 in range(len(bpy.context.scene.sna_cr_rigicar_objects_col)):
                    if (bpy.context.scene.sna_cr_rigicar_objects_col[i_C7D23].rigicar_object == bpy.data.objects[i_5F507]):
                        pass
                    else:
                        sna_fu_add_rigicar_col_object_1E008(bpy.context.scene.sna_cr_rigicar_objects_col, bpy.data.objects[i_5F507])
                object = bpy.data.objects[i_5F507]

                def select_active(ob):
                    ob.select_set(True)
                    bpy.context.view_layer.objects.active = ob
                bpy.ops.object.select_all(action='DESELECT')
                select_active(object)
                car = bpy.data.objects[i_5F507]

                def select_active(ob):
                    bpy.ops.object.select_all(action='DESELECT')
                    ob.select_set(True)
                    bpy.context.view_layer.objects.active = ob
                car.sna_cr_sb_global_spring = False
                bpy.context.scene.frame_set(bpy.context.scene.frame_start)
                car_rig = car.sna_cr_id_collec[0]['rig']
                car.sna_cr_id_collec[0]['wheel_ard'].hide_select = True
                car.sna_cr_id_collec[0]['wheel_arg'].hide_select = True
                car.sna_cr_id_collec[0]['wheel_avd'].hide_select = True
                select_active(car_rig)
                bpy.ops.object.select_grouped(type='CHILDREN')
                rigicar_custom_objs = bpy.context.selected_objects
                for o_tmp in [car, car.sna_cr_wheel_avg]:
                    if o_tmp in rigicar_custom_objs:
                        rigicar_custom_objs.remove(o_tmp)
                ################### STORE RELATIONS OF CARRIG CHILDREN
                matrix_dict = {}
                for o in rigicar_custom_objs:
                    matrix_dict[o] = car_rig.matrix_world@o.matrix_local
                    o['tmp_parent_type'] = o.parent_type
                    if o.parent_type == 'BONE':
                        o['tmp_parent_bone'] = o.parent_bone
                    o.parent = None
                ######################################################
                #self.report({'INFO'}, message=str(rigicar_custom_objs))
                select_active(car)
                wheel_rot = None
                rigicar_path = None
                rigicar_ground = None
                car.rotation_mode = 'XYZ'
                car_rot = copy.copy(car.rotation_euler)
                car_pos = copy.copy(car.location)
                # to disable modal algn operator:
                carrig_setup['sna_cr_bool_tmp'] = True
                car_id = car.sna_cr_id_collec
                try:
                    wheel = car.sna_cr_wheel_avg
                    wheel.rotation_mode = 'XYZ'
                    wheel_rot = copy.copy(wheel.rotation_euler)   
                except:
                    print('no ref wheel...')
                try:
                    rigicar_path = car.sna_cr_carrig_curve
                    #rigicar_path.name += '_old'
                    #rigicar_path_pos = copy.copy(rigicar_path.location)
                except:
                    print("no path...")
                try:
                    if rigicar_path == car_id[0].path_curve:
                        tmp = rigicar_path.name
                        select_active(car.sna_cr_carrig_curve)
                        bpy.ops.object.duplicate_move(OBJECT_OT_duplicate={"linked":False, "mode":'TRANSLATION'}, TRANSFORM_OT_translate={"value":(0, 0, 0), "orient_axis_ortho":'X', "orient_type":'GLOBAL', "orient_matrix":((0, 0, 0), (0, 0, 0), (0, 0, 0)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "view2d_edge_pan":False, "release_confirm":False, "use_accurate":False, "use_automerge_and_split":False})
                        rigicar_path = bpy.context.object
                        #rigicar_path.name += '_dupli'
                        car_id[0].path_curve = bpy.data.objects[tmp]
                except:
                    print('no path...')
                try:
                    rigicar_ground = car.sna_cr_ground_obj
                except:
                    print('no ground...')
                select_active(car)
                bpy.ops.sna.cr_op_copy_parametters_18d32()
                if car.animation_data.action:
                    action = car.animation_data.action
                    car.animation_data.action.use_fake_user = True
                    car.animation_data.action = None
                    bpy.ops.sna.cr_op_toggle_90495()    
                    bpy.ops.sna.cr_op_toggle_90495()
                    car.animation_data.action = action
                else:    
                    bpy.ops.sna.cr_op_toggle_90495()    
                    bpy.ops.sna.cr_op_toggle_90495()
                bpy.ops.sna.cr_op_paste_parametters_52b4d(sna_all_cars='Selected RigiCar')
                if wheel_rot:
                    car.sna_cr_wheel_avg = wheel
                    car.sna_cr_wheel_avg.rotation_euler = wheel_rot
                    car_id[0].wheel_avd.rotation_euler = wheel_rot
                    car_id[0].wheel_ard.rotation_euler = wheel_rot
                    car_id[0].wheel_arg.rotation_euler = wheel_rot
                if rigicar_path:
                    #rigicar_path.name += '_updated'
                    car.sna_cr_carrig_curve = rigicar_path
                    #rigicar_path.location = rigicar_path_pos
                if rigicar_ground:
                    car.sna_cr_ground_obj = rigicar_ground
                car.rotation_euler = car_rot
                car.location = car_pos
                # to enable modal algn operator:
                carrig_setup['sna_cr_bool_tmp'] = False
                bpy.ops.object.select_all(action='DESELECT')
                new_rig = car.sna_cr_id_collec[0]['rig']
                #self.report({'INFO'}, message='le new rig =' + new_rig.name)
                for o in rigicar_custom_objs:
                    o.parent = new_rig
                    o.parent_type = o['tmp_parent_type']
                    if o.parent_type == 'BONE':
                        o.parent_bone = o['tmp_parent_bone']
                    o.matrix_local = matrix_dict[o]
                select_active(car)
            object = carrig_setup['sna_object_tmp']

            def select_active(ob):
                ob.select_set(True)
                bpy.context.view_layer.objects.active = ob
            bpy.ops.object.select_all(action='DESELECT')
            select_active(object)
        return {"FINISHED"}

    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)


class SNA_PT_setup_9AF9E(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_setup_9AF9E'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 0
    bl_options = {'HEADER_LAYOUT_EXPAND'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (sna_rc_fu_test_rigicar_6C34F())

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='Setup', icon_value=233)

    def draw(self, context):
        layout = self.layout
        box_83255 = layout.box()
        box_83255.alert = False
        box_83255.enabled = True
        box_83255.active = True
        box_83255.use_property_split = False
        box_83255.use_property_decorate = True
        box_83255.alignment = 'Expand'.upper()
        box_83255.scale_x = 1.0
        box_83255.scale_y = 1.0
        row_88B4B = box_83255.row(heading='', align=False)
        row_88B4B.alert = False
        row_88B4B.enabled = True
        row_88B4B.active = True
        row_88B4B.use_property_split = False
        row_88B4B.use_property_decorate = False
        row_88B4B.scale_x = 1.0
        row_88B4B.scale_y = 1.0
        row_88B4B.alignment = 'Expand'.upper()
        row_88B4B.label(text='', icon_value=_icons['car_caisse_icon.png'].icon_id)
        row_88B4B.label(text=list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig.name, icon_value=0)
        op = row_88B4B.operator('sna.cr_mop_algin_car_c9dcf', text='', icon_value=594, emboss=True, depress=False)
        op.sna_pos_x = 0
        op.sna_pos_y = 0
        row_CC39C = box_83255.row(heading='', align=False)
        row_CC39C.alert = False
        row_CC39C.enabled = True
        row_CC39C.active = True
        row_CC39C.use_property_split = False
        row_CC39C.use_property_decorate = False
        row_CC39C.scale_x = 1.0
        row_CC39C.scale_y = 1.0
        row_CC39C.alignment = 'Expand'.upper()
        row_CC39C.label(text='', icon_value=_icons['car_flat_wheel_icon.png'].icon_id)
        row_CC39C.prop_search(bpy.context.view_layer.objects.active, 'sna_cr_wheel_avg', bpy.data, 'objects', text='', icon='NONE')
        op = row_CC39C.operator('sna.cr_mop_algin_wheels_f10c6', text='', icon_value=594, emboss=True, depress=False)
        op.sna_pos_x = 0
        op.sna_pos_y = 0
        row_0D9E4 = box_83255.row(heading='', align=True)
        row_0D9E4.alert = False
        row_0D9E4.enabled = True
        row_0D9E4.active = True
        row_0D9E4.use_property_split = False
        row_0D9E4.use_property_decorate = False
        row_0D9E4.scale_x = 2.0
        row_0D9E4.scale_y = 2.0
        row_0D9E4.alignment = 'Expand'.upper()
        row_0D9E4.template_icon(icon_value=_icons['car_long_icon.png'].icon_id, scale=1.0)
        row_0D9E4.separator(factor=1.0)
        row_0D9E4.template_icon(icon_value=_icons['car_large_icon.png'].icon_id, scale=1.0)
        row_0D9E4.separator(factor=1.0)
        row_0D9E4.template_icon(icon_value=_icons['car_scale_wheel_icon.png'].icon_id, scale=1.0)
        row_C95DD = box_83255.row(heading='', align=False)
        row_C95DD.alert = False
        row_C95DD.enabled = True
        row_C95DD.active = True
        row_C95DD.use_property_split = False
        row_C95DD.use_property_decorate = False
        row_C95DD.scale_x = 1.0
        row_C95DD.scale_y = 1.0
        row_C95DD.alignment = 'Expand'.upper()
        row_C95DD.prop(bpy.context.view_layer.objects.active, 'sna_cr_chassis_large', text='', icon_value=0, emboss=True, slider=False)
        row_C95DD.prop(bpy.context.view_layer.objects.active, 'sna_cr_chassis_long', text='', icon_value=0, emboss=True)
        row_C95DD.prop(bpy.context.view_layer.objects.active, 'sna_cr_wheel_scale', text='', icon_value=0, emboss=True)
        row_03F3C = layout.row(heading='', align=False)
        row_03F3C.alert = False
        row_03F3C.enabled = True
        row_03F3C.active = True
        row_03F3C.use_property_split = False
        row_03F3C.use_property_decorate = False
        row_03F3C.scale_x = 1.0
        row_03F3C.scale_y = 1.0
        row_03F3C.alignment = 'Expand'.upper()
        if not True: row_03F3C.operator_context = "EXEC_DEFAULT"
        row_03F3C.prop(bpy.context.view_layer.objects.active, 'sna_cr_view_rig', text='', icon_value=_icons['anchor_icon.png'].icon_id, emboss=True)
        row_03F3C.label(text='Anchors Helpers', icon_value=0)
        row_43EF2 = layout.row(heading='', align=False)
        row_43EF2.alert = False
        row_43EF2.enabled = True
        row_43EF2.active = True
        row_43EF2.use_property_split = False
        row_43EF2.use_property_decorate = False
        row_43EF2.scale_x = 1.0
        row_43EF2.scale_y = 1.0
        row_43EF2.alignment = 'Right'.upper()
        if not True: row_43EF2.operator_context = "EXEC_DEFAULT"
        row_03F3C.label(text='', icon_value=_icons['car_soft_ground_icon.png'].icon_id)
        attr_D6F81 = '["' + str('CarRig_Ground_Softing' + '"]') 
        row_03F3C.prop(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig, attr_D6F81, text='Ground Softing', icon_value=447, emboss=True, expand=True, slider=False)
        box_2EB91 = layout.box()
        box_2EB91.alert = False
        box_2EB91.enabled = True
        box_2EB91.active = True
        box_2EB91.use_property_split = False
        box_2EB91.use_property_decorate = False
        box_2EB91.alignment = 'Expand'.upper()
        box_2EB91.scale_x = 1.0
        box_2EB91.scale_y = 1.0
        box_2EB91.prop(bpy.context.view_layer.objects.active, 'sna_cr_carrig_curve', text='path', icon_value=457, emboss=True)
        box_2EB91.prop(bpy.context.view_layer.objects.active, 'sna_cr_ground_obj', text='', icon_value=775, emboss=True)


class SNA_PT_animation_BA400(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_animation_BA400'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 1
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (sna_rc_fu_test_rigicar_6C34F())

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='Animation', icon_value=146)

    def draw(self, context):
        layout = self.layout
        box_97B15 = layout.box()
        box_97B15.alert = False
        box_97B15.enabled = True
        box_97B15.active = True
        box_97B15.use_property_split = False
        box_97B15.use_property_decorate = True
        box_97B15.alignment = 'Expand'.upper()
        box_97B15.scale_x = 1.0
        box_97B15.scale_y = 1.0
        row_C9BA0 = box_97B15.row(heading='', align=False)
        row_C9BA0.alert = False
        row_C9BA0.enabled = True
        row_C9BA0.active = True
        row_C9BA0.use_property_split = True
        row_C9BA0.use_property_decorate = True
        row_C9BA0.scale_x = 1.0
        row_C9BA0.scale_y = 1.0
        row_C9BA0.alignment = 'Expand'.upper()
        row_C9BA0.label(text='', icon_value=167)
        row_C9BA0.prop(bpy.context.view_layer.objects.active, 'sna_cr_path_distance', text='', icon_value=0, emboss=True)
        row_EB7FD = box_97B15.row(heading='', align=False)
        row_EB7FD.alert = True
        row_EB7FD.enabled = False
        row_EB7FD.active = True
        row_EB7FD.use_property_split = False
        row_EB7FD.use_property_decorate = False
        row_EB7FD.scale_x = 1.0
        row_EB7FD.scale_y = 1.0
        row_EB7FD.alignment = 'Expand'.upper()
        row_EB7FD.label(text='', icon_value=_icons['car_speed_icon.png'].icon_id)
        row_EB7FD.prop(bpy.context.view_layer.objects.active, 'sna_cr_instant_speed', text='', icon_value=0, emboss=True)
        row_EB7FD.label(text='km/h', icon_value=0)
        row_5A680 = box_97B15.row(heading='', align=False)
        row_5A680.alert = False
        row_5A680.enabled = True
        row_5A680.active = True
        row_5A680.use_property_split = False
        row_5A680.use_property_decorate = False
        row_5A680.scale_x = 2.0
        row_5A680.scale_y = 2.0
        row_5A680.alignment = 'Expand'.upper()
        row_5A680.template_icon(icon_value=_icons['car_bank_icon.png'].icon_id, scale=1.0)
        row_5A680.separator(factor=1.0)
        row_5A680.template_icon(icon_value=_icons['car_acc_icon.png'].icon_id, scale=1.0)
        row_70B71 = box_97B15.row(heading='', align=False)
        row_70B71.alert = False
        row_70B71.enabled = True
        row_70B71.active = True
        row_70B71.use_property_split = False
        row_70B71.use_property_decorate = False
        row_70B71.scale_x = 1.0
        row_70B71.scale_y = 1.0
        row_70B71.alignment = 'Expand'.upper()
        row_70B71.prop(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig, '["CarRig_Bank_factor"]', text='', icon_value=0, emboss=True)
        row_70B71.prop(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig, '["CarRig_Acc_Factor"]', text='', icon_value=0, emboss=True)
        row_F22EA = box_97B15.row(heading='', align=False)
        row_F22EA.alert = False
        row_F22EA.enabled = True
        row_F22EA.active = True
        row_F22EA.use_property_split = False
        row_F22EA.use_property_decorate = False
        row_F22EA.scale_x = 1.0
        row_F22EA.scale_y = 1.0
        row_F22EA.alignment = 'Expand'.upper()
        split_E36E1 = row_F22EA.split(factor=0.5, align=False)
        split_E36E1.alert = False
        split_E36E1.enabled = True
        split_E36E1.active = True
        split_E36E1.use_property_split = False
        split_E36E1.use_property_decorate = False
        split_E36E1.scale_x = 1.0
        split_E36E1.scale_y = 1.0
        split_E36E1.alignment = 'Expand'.upper()
        col_F7CBC = split_E36E1.column(heading='', align=False)
        col_F7CBC.alert = False
        col_F7CBC.enabled = True
        col_F7CBC.active = True
        col_F7CBC.use_property_split = False
        col_F7CBC.use_property_decorate = False
        col_F7CBC.scale_x = 1.0
        col_F7CBC.scale_y = 1.0
        col_F7CBC.alignment = 'Expand'.upper()
        row_5CAFF = col_F7CBC.row(heading='', align=False)
        row_5CAFF.alert = False
        row_5CAFF.enabled = True
        row_5CAFF.active = True
        row_5CAFF.use_property_split = False
        row_5CAFF.use_property_decorate = False
        row_5CAFF.scale_x = 1.0
        row_5CAFF.scale_y = 1.0
        row_5CAFF.alignment = 'Expand'.upper()
        row_5CAFF.label(text='', icon_value=_icons['car_drift_icon.png'].icon_id)
        row_5CAFF.prop(list(bpy.context.view_layer.objects.active.sna_cr_id_collec)[0].rig, '["CarRig_Drift_Bank_factor"]', text='', icon_value=0, emboss=True)
        col_9FF4D = split_E36E1.column(heading='', align=False)
        col_9FF4D.alert = False
        col_9FF4D.enabled = True
        col_9FF4D.active = True
        col_9FF4D.use_property_split = False
        col_9FF4D.use_property_decorate = False
        col_9FF4D.scale_x = 1.0
        col_9FF4D.scale_y = 1.0
        col_9FF4D.alignment = 'Expand'.upper()
        row_ED214 = col_9FF4D.row(heading='', align=False)
        row_ED214.alert = False
        row_ED214.enabled = True
        row_ED214.active = True
        row_ED214.use_property_split = False
        row_ED214.use_property_decorate = False
        row_ED214.scale_x = 1.0
        row_ED214.scale_y = 1.0
        row_ED214.alignment = 'Expand'.upper()
        row_ED214.label(text='', icon_value=527)
        row_ED214.prop(bpy.context.view_layer.objects.active, 'sna_cr_interpol_duration_factor', text='', icon_value=0, emboss=True, slider=True)


class SNA_PT_dampers_6766F(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_dampers_6766F'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 3
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (sna_rc_fu_test_rigicar_6C34F())

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='Dampers', icon_value=341)

    def draw(self, context):
        layout = self.layout
        box_4F5EF = layout.box()
        box_4F5EF.alert = False
        box_4F5EF.enabled = True
        box_4F5EF.active = True
        box_4F5EF.use_property_split = False
        box_4F5EF.use_property_decorate = False
        box_4F5EF.alignment = 'Expand'.upper()
        box_4F5EF.scale_x = 1.0
        box_4F5EF.scale_y = 1.0
        box_4F5EF.prop(bpy.context.view_layer.objects.active, 'sna_cr_sb_global_spring', text='Dampers', icon_value=_icons['car_spring_ico.png'].icon_id, emboss=True)
        if bpy.context.view_layer.objects.active.sna_cr_sb_global_spring:
            col_AC438 = box_4F5EF.column(heading='', align=False)
            col_AC438.alert = False
            col_AC438.enabled = True
            col_AC438.active = True
            col_AC438.use_property_split = False
            col_AC438.use_property_decorate = False
            col_AC438.scale_x = 1.0
            col_AC438.scale_y = 1.0
            col_AC438.alignment = 'Expand'.upper()
            row_1B600 = col_AC438.row(heading='', align=False)
            row_1B600.alert = False
            row_1B600.enabled = True
            row_1B600.active = True
            row_1B600.use_property_split = False
            row_1B600.use_property_decorate = False
            row_1B600.scale_x = 1.0
            row_1B600.scale_y = 1.0
            row_1B600.alignment = 'Expand'.upper()
            row_1B600.label(text='', icon_value=41)
            row_1B600.prop(bpy.context.view_layer.objects.active, 'sna_cr_sb_lock_z_axis', text='lock Z', icon_value=0, emboss=True)
            row_039E6 = col_AC438.row(heading='', align=False)
            row_039E6.alert = False
            row_039E6.enabled = True
            row_039E6.active = True
            row_039E6.use_property_split = False
            row_039E6.use_property_decorate = False
            row_039E6.scale_x = 1.0
            row_039E6.scale_y = 1.0
            row_039E6.alignment = 'Expand'.upper()
            row_039E6.label(text='', icon_value=652)
            row_039E6.prop(bpy.context.view_layer.objects.active, 'sna_cr_sb_spring_stiffness', text='stiffness', icon_value=732, emboss=True, slider=True)
            row_8E885 = col_AC438.row(heading='', align=False)
            row_8E885.alert = False
            row_8E885.enabled = True
            row_8E885.active = True
            row_8E885.use_property_split = False
            row_8E885.use_property_decorate = False
            row_8E885.scale_x = 1.0
            row_8E885.scale_y = 1.0
            row_8E885.alignment = 'Expand'.upper()
            row_8E885.label(text='', icon_value=536)
            row_8E885.prop(bpy.context.view_layer.objects.active, 'sna_cr_sb_spring_damp', text='damping', icon_value=536, emboss=True, slider=True)
            col_AC438.prop(bpy.context.view_layer.objects.active, 'sna_cr_sb_spring_global_influence', text='influence', icon_value=0, emboss=True, slider=True)


class SNA_PT_bake_3A112(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_bake_3A112'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 4
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (sna_rc_fu_test_rigicar_6C34F())

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='Bake', icon_value=404)

    def draw(self, context):
        layout = self.layout
        box_35116 = layout.box()
        box_35116.alert = False
        box_35116.enabled = True
        box_35116.active = True
        box_35116.use_property_split = False
        box_35116.use_property_decorate = False
        box_35116.alignment = 'Expand'.upper()
        box_35116.scale_x = 1.0
        box_35116.scale_y = 1.0
        op = box_35116.operator('sna.cr_op_bake_2_meshes_8f15d', text='Bake To Keyframes', icon_value=115, emboss=True, depress=False)
        op.sna_all = 'Selected RigiCar'
        op.sna_start = 0
        op.sna_end = 0


class SNA_PT_about_5C7F0(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_about_5C7F0'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 5
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (False)

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='About', icon_value=110)

    def draw(self, context):
        layout = self.layout
        layout_function = layout
        sna_interface_about_pictofilmo_5B4B0(layout_function, )


class SNA_PT_advanced_animation_0FE09(bpy.types.Panel):
    bl_label = ''
    bl_idname = 'SNA_PT_advanced_animation_0FE09'
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_context = ''
    bl_order = 2
    bl_options = {'DEFAULT_CLOSED'}
    bl_parent_id = 'SNA_PT_RIGICAR_13EF3'
    bl_ui_units_x=0

    @classmethod
    def poll(cls, context):
        return not (sna_rc_fu_test_rigicar_6C34F())

    def draw_header(self, context):
        layout = self.layout
        layout.label(text='Advanced Animation', icon_value=409)

    def draw(self, context):
        layout = self.layout
        box_AD528 = layout.box()
        box_AD528.alert = False
        box_AD528.enabled = True
        box_AD528.active = True
        box_AD528.use_property_split = False
        box_AD528.use_property_decorate = False
        box_AD528.alignment = 'Expand'.upper()
        box_AD528.scale_x = 1.0
        box_AD528.scale_y = 1.0
        if not True: box_AD528.operator_context = "EXEC_DEFAULT"
        row_33B78 = box_AD528.row(heading='', align=False)
        row_33B78.alert = False
        row_33B78.enabled = True
        row_33B78.active = True
        row_33B78.use_property_split = True
        row_33B78.use_property_decorate = False
        row_33B78.scale_x = 1.0
        row_33B78.scale_y = 1.0
        row_33B78.alignment = 'Expand'.upper()
        if not True: row_33B78.operator_context = "EXEC_DEFAULT"
        row_33B78.template_icon(icon_value=_icons['car_drift_icon.png'].icon_id, scale=2.0)
        col_E6964 = row_33B78.column(heading='', align=True)
        col_E6964.alert = False
        col_E6964.enabled = True
        col_E6964.active = True
        col_E6964.use_property_split = False
        col_E6964.use_property_decorate = False
        col_E6964.scale_x = 1.0
        col_E6964.scale_y = 1.0
        col_E6964.alignment = 'Expand'.upper()
        if not True: col_E6964.operator_context = "EXEC_DEFAULT"
        col_E6964.label(text='Drifts:', icon_value=0)
        split_A0B0D = col_E6964.split(factor=0.10000000149011612, align=True)
        split_A0B0D.alert = False
        split_A0B0D.enabled = True
        split_A0B0D.active = True
        split_A0B0D.use_property_split = True
        split_A0B0D.use_property_decorate = False
        split_A0B0D.scale_x = 1.0
        split_A0B0D.scale_y = 1.0
        split_A0B0D.alignment = 'Expand'.upper()
        if not True: split_A0B0D.operator_context = "EXEC_DEFAULT"
        split_A0B0D.label(text='L', icon_value=0)
        split_6BE78 = split_A0B0D.split(factor=0.8999999761581421, align=True)
        split_6BE78.alert = False
        split_6BE78.enabled = True
        split_6BE78.active = True
        split_6BE78.use_property_split = False
        split_6BE78.use_property_decorate = False
        split_6BE78.scale_x = 1.0
        split_6BE78.scale_y = 1.0
        split_6BE78.alignment = 'Expand'.upper()
        if not True: split_6BE78.operator_context = "EXEC_DEFAULT"
        split_6BE78.prop(bpy.context.view_layer.objects.active, 'sna_cr_drift', text='', icon_value=0, emboss=True, slider=True)
        split_6BE78.label(text='R', icon_value=0)
        row_0F145 = box_AD528.row(heading='', align=False)
        row_0F145.alert = False
        row_0F145.enabled = True
        row_0F145.active = True
        row_0F145.use_property_split = False
        row_0F145.use_property_decorate = False
        row_0F145.scale_x = 1.0
        row_0F145.scale_y = 1.0
        row_0F145.alignment = 'Expand'.upper()
        if not True: row_0F145.operator_context = "EXEC_DEFAULT"
        row_0F145.template_icon(icon_value=_icons['car_torque_icon.png'].icon_id, scale=2.0)
        col_1CBCC = row_0F145.column(heading='', align=True)
        col_1CBCC.alert = False
        col_1CBCC.enabled = True
        col_1CBCC.active = True
        col_1CBCC.use_property_split = False
        col_1CBCC.use_property_decorate = False
        col_1CBCC.scale_x = 1.0
        col_1CBCC.scale_y = 1.0
        col_1CBCC.alignment = 'Expand'.upper()
        if not True: col_1CBCC.operator_context = "EXEC_DEFAULT"
        col_1CBCC.label(text='Torque:', icon_value=0)
        row_60C02 = col_1CBCC.row(heading='', align=False)
        row_60C02.alert = False
        row_60C02.enabled = True
        row_60C02.active = True
        row_60C02.use_property_split = True
        row_60C02.use_property_decorate = True
        row_60C02.scale_x = 1.0
        row_60C02.scale_y = 1.0
        row_60C02.alignment = 'Expand'.upper()
        if not True: row_60C02.operator_context = "EXEC_DEFAULT"
        row_60C02.prop(bpy.context.view_layer.objects.active, 'sna_cr_torque', text='', icon_value=0, emboss=True, slider=True)
        row_9131B = row_60C02.row(heading='', align=False)
        row_9131B.alert = False
        row_9131B.enabled = True
        row_9131B.active = True
        row_9131B.use_property_split = False
        row_9131B.use_property_decorate = False
        row_9131B.scale_x = 1.0
        row_9131B.scale_y = 1.0
        row_9131B.alignment = 'Expand'.upper()
        if not True: row_9131B.operator_context = "EXEC_DEFAULT"
        row_9131B.prop(bpy.context.view_layer.objects.active, 'sna_cr_transmission_mode', text='', icon_value=0, emboss=True, expand=False, slider=True)
        row_01637 = box_AD528.row(heading='', align=False)
        row_01637.alert = False
        row_01637.enabled = True
        row_01637.active = True
        row_01637.use_property_split = False
        row_01637.use_property_decorate = False
        row_01637.scale_x = 1.0
        row_01637.scale_y = 1.0
        row_01637.alignment = 'Expand'.upper()
        if not True: row_01637.operator_context = "EXEC_DEFAULT"
        row_01637.template_icon(icon_value=_icons['car_counter_steering_icon.png'].icon_id, scale=2.0)
        col_21D43 = row_01637.column(heading='', align=True)
        col_21D43.alert = False
        col_21D43.enabled = True
        col_21D43.active = True
        col_21D43.use_property_split = True
        col_21D43.use_property_decorate = True
        col_21D43.scale_x = 1.0
        col_21D43.scale_y = 1.0
        col_21D43.alignment = 'Expand'.upper()
        if not True: col_21D43.operator_context = "EXEC_DEFAULT"
        col_21D43.label(text='Over Streering:', icon_value=0)
        col_21D43.prop(bpy.context.view_layer.objects.active, 'sna_cr_counter_steering', text='', icon_value=0, emboss=True, slider=True)
        box_01FBE = layout.box()
        box_01FBE.alert = False
        box_01FBE.enabled = True
        box_01FBE.active = True
        box_01FBE.use_property_split = False
        box_01FBE.use_property_decorate = False
        box_01FBE.alignment = 'Expand'.upper()
        box_01FBE.scale_x = 1.0
        box_01FBE.scale_y = 1.0
        if not True: box_01FBE.operator_context = "EXEC_DEFAULT"
        row_FCD82 = box_01FBE.row(heading='', align=False)
        row_FCD82.alert = False
        row_FCD82.enabled = True
        row_FCD82.active = True
        row_FCD82.use_property_split = False
        row_FCD82.use_property_decorate = False
        row_FCD82.scale_x = 1.0
        row_FCD82.scale_y = 1.0
        row_FCD82.alignment = 'Expand'.upper()
        if not True: row_FCD82.operator_context = "EXEC_DEFAULT"
        row_FCD82.template_icon(icon_value=_icons['car_jump_icon.png'].icon_id, scale=2.0)
        col_3452E = row_FCD82.column(heading='', align=True)
        col_3452E.alert = False
        col_3452E.enabled = True
        col_3452E.active = True
        col_3452E.use_property_split = True
        col_3452E.use_property_decorate = True
        col_3452E.scale_x = 1.0
        col_3452E.scale_y = 1.0
        col_3452E.alignment = 'Expand'.upper()
        if not True: col_3452E.operator_context = "EXEC_DEFAULT"
        col_3452E.prop(bpy.context.view_layer.objects.active, 'sna_cr_jump_fr', text='Front', icon_value=0, emboss=True, slider=True)
        col_3452E.prop(bpy.context.view_layer.objects.active, 'sna_cr_jump_bk', text='Back', icon_value=0, emboss=True, slider=True)
        box_9B5E6 = layout.box()
        box_9B5E6.alert = False
        box_9B5E6.enabled = True
        box_9B5E6.active = True
        box_9B5E6.use_property_split = False
        box_9B5E6.use_property_decorate = False
        box_9B5E6.alignment = 'Expand'.upper()
        box_9B5E6.scale_x = 1.0
        box_9B5E6.scale_y = 1.0
        if not True: box_9B5E6.operator_context = "EXEC_DEFAULT"
        row_9EFA4 = box_9B5E6.row(heading='', align=False)
        row_9EFA4.alert = False
        row_9EFA4.enabled = True
        row_9EFA4.active = True
        row_9EFA4.use_property_split = False
        row_9EFA4.use_property_decorate = False
        row_9EFA4.scale_x = 1.0
        row_9EFA4.scale_y = 1.0
        row_9EFA4.alignment = 'Expand'.upper()
        if not True: row_9EFA4.operator_context = "EXEC_DEFAULT"
        row_9EFA4.template_icon(icon_value=_icons['brake_icon.png'].icon_id, scale=2.0)
        col_E947F = row_9EFA4.column(heading='', align=True)
        col_E947F.alert = False
        col_E947F.enabled = True
        col_E947F.active = True
        col_E947F.use_property_split = True
        col_E947F.use_property_decorate = True
        col_E947F.scale_x = 1.0
        col_E947F.scale_y = 1.0
        col_E947F.alignment = 'Expand'.upper()
        if not True: col_E947F.operator_context = "EXEC_DEFAULT"
        col_E947F.prop(bpy.context.view_layer.objects.active, 'sna_cr_brake_fr', text='Front', icon_value=0, emboss=True, slider=True)
        col_E947F.prop(bpy.context.view_layer.objects.active, 'sna_cr_brake_bk', text='Back', icon_value=0, emboss=True, slider=True)


class SNA_GROUP_sna_cr_id_group(bpy.types.PropertyGroup):
    rig: bpy.props.PointerProperty(name='rig', description='', type=bpy.types.Object)
    path_curve: bpy.props.PointerProperty(name='path_curve', description='', type=bpy.types.Object)
    wheel_avd: bpy.props.PointerProperty(name='wheel_avd', description='', type=bpy.types.Object)
    wheel_ard: bpy.props.PointerProperty(name='wheel_ard', description='', type=bpy.types.Object)
    wheel_arg: bpy.props.PointerProperty(name='wheel_arg', description='', type=bpy.types.Object)


class SNA_GROUP_sna_cr_sb_spring_group(bpy.types.PropertyGroup):
    bone_spring_name: bpy.props.StringProperty(name='bone_spring_name', description='', default='', subtype='NONE', maxlen=0)
    speed_spring: bpy.props.FloatVectorProperty(name='speed_spring', description='', size=3, default=(0.0, 0.0, 0.0), subtype='TRANSLATION', unit='NONE', step=3, precision=6)


class SNA_GROUP_sna_cr_rigicar_objects_col_group(bpy.types.PropertyGroup):
    rigicar_object: bpy.props.PointerProperty(name='rigicar_object', description='', type=bpy.types.Object)


def register():
    global _icons
    _icons = bpy.utils.previews.new()
    bpy.utils.register_class(SNA_GROUP_sna_cr_id_group)
    bpy.utils.register_class(SNA_GROUP_sna_cr_sb_spring_group)
    bpy.utils.register_class(SNA_GROUP_sna_cr_rigicar_objects_col_group)
    bpy.types.Object.sna_cr_bool = bpy.props.BoolProperty(name='cr_bool', description='', default=False)
    bpy.types.Object.sna_cr_wheel_avg = bpy.props.PointerProperty(name='cr_wheel_avg', description='', type=bpy.types.Object, update=sna_update_sna_cr_wheel_avg_CB0F2)
    bpy.types.Object.sna_cr_carrig_curve = bpy.props.PointerProperty(name='cr_carrig_curve', description='', type=bpy.types.Object, update=sna_update_sna_cr_carrig_curve_B7497)
    bpy.types.Object.sna_cr_id_collec = bpy.props.CollectionProperty(name='cr_id_collec', description='', type=SNA_GROUP_sna_cr_id_group)
    bpy.types.Object.sna_cr_offset_factor = bpy.props.FloatProperty(name='cr_offset_factor', description='', default=0.0, subtype='NONE', unit='NONE', step=3, precision=6)
    bpy.types.Object.sna_cr_chassis_large = bpy.props.FloatProperty(name='cr_chassis_large', description='Value between front and back wheels. This is a scale value, not a distance.', default=1.0, subtype='NONE', unit='NONE', step=3, precision=2, update=sna_update_sna_cr_chassis_large_F70FE)
    bpy.types.Object.sna_cr_chassis_long = bpy.props.FloatProperty(name='cr_chassis_long', description='Value between right and left wheels. This is a scale value, not a distance.', default=1.0, subtype='NONE', unit='NONE', min=0.10000000149011612, max=20.0, step=3, precision=2, update=sna_update_sna_cr_chassis_long_AAFA8)
    bpy.types.Object.sna_cr_wheel_radius = bpy.props.FloatProperty(name='cr_wheel_radius', description='', default=0.0, subtype='NONE', unit='NONE', min=0.009999999776482582, step=3, precision=6)
    bpy.types.Object.sna_cr_path_distance = bpy.props.FloatProperty(name='cr_path_distance', description='Animate this value to move the vehicle along the spline', options={'ANIMATABLE'}, default=0.0, subtype='DISTANCE', unit='LENGTH', min=0.0, step=3, precision=6, update=sna_update_sna_cr_path_distance_FDA27)
    bpy.types.Object.sna_cr_instant_speed = bpy.props.FloatProperty(name='cr_instant_speed', description='Current vehicle speed in km/h', default=0.0, subtype='NONE', unit='NONE', step=3, precision=3)
    bpy.types.Scene.sna_debug = bpy.props.FloatProperty(name='debug', description='', default=0.0, subtype='NONE', unit='NONE', step=3, precision=6)
    bpy.types.Scene.sna_cr_modal_activ = bpy.props.BoolProperty(name='cr_modal_activ', description='', default=False)
    bpy.types.Object.sna_cr_ground_obj = bpy.props.PointerProperty(name='cr_ground_obj', description='Pick the ground object', type=bpy.types.Object, update=sna_update_sna_cr_ground_obj_8D338)
    bpy.types.Object.sna_cr_frame_interpol = bpy.props.IntProperty(name='cr_frame_interpol', description='', default=-1, subtype='NONE')
    bpy.types.Object.sna_cr_interpol_duration = bpy.props.IntProperty(name='cr_interpol_duration', description='', default=6, subtype='NONE', min=1)
    bpy.types.Object.sna_cr_interpol_duration_factor = bpy.props.IntProperty(name='cr_interpol_duration_factor', description='duration in frames of the interpolation of acceleration', default=1, subtype='NONE', min=1, max=30)
    bpy.types.Object.sna_cr_sb_global_spring = bpy.props.BoolProperty(name='cr_sb_global_spring', description='', default=False, update=sna_update_sna_cr_sb_global_spring_66507)
    bpy.types.Object.sna_cr_sb_spring_stiffness = bpy.props.FloatProperty(name='cr_sb_spring_stiffness', description='', default=0.5, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=6)
    bpy.types.Object.sna_cr_sb_spring_damp = bpy.props.FloatProperty(name='cr_sb_spring_damp', description='', default=0.699999988079071, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=6)
    bpy.types.Object.sna_cr_sb_spring_global_influence = bpy.props.FloatProperty(name='cr_sb_spring_global_influence', description='', default=1.0, subtype='NONE', unit='NONE', min=0.009999999776482582, max=1.0, step=3, precision=6)
    bpy.types.Object.sna_cr_sb_lock_z_axis = bpy.props.BoolProperty(name='cr_sb_lock_z_axis', description='', default=True)
    bpy.types.Object.sna_cr_sb_spring_bones_col = bpy.props.CollectionProperty(name='cr_sb_spring_bones_col', description='', type=SNA_GROUP_sna_cr_sb_spring_group)
    bpy.types.Object.sna_cr_spring_list_index = bpy.props.IntProperty(name='cr_spring_list_index', description='', default=0, subtype='NONE', min=0, max=3)
    bpy.types.Object.sna_debug_state = bpy.props.StringProperty(name='debug_state', description='', default='state...', subtype='NONE', maxlen=0)
    bpy.types.Object.sna_cr_path_curve_len = bpy.props.FloatProperty(name='cr_path_curve_len', description='', default=0.0, subtype='DISTANCE', unit='NONE', min=0.009999999776482582, step=3, precision=6)
    bpy.types.Object.sna_cr_view_rig = bpy.props.BoolProperty(name='cr_view_rig', description='', default=False, update=sna_update_sna_cr_view_rig_3E926)
    bpy.types.Object.sna_cr_torque = bpy.props.FloatProperty(name='cr_torque', description='', default=0.0, subtype='NONE', unit='NONE', min=0.0, max=10.0, step=3, precision=3)
    bpy.types.Object.sna_cr_transmission_mode = bpy.props.EnumProperty(name='cr_transmission_mode', description='', items=[('TRACTION', 'TRACTION', '', 718, 0), ('PROPULSION', 'PROPULSION', '', 717, 1), ('4X4', '4X4', '', 8, 2)])
    bpy.types.Object.sna_cr_counter_steering = bpy.props.FloatProperty(name='cr_counter_steering', description='', default=0.0, subtype='ANGLE', unit='NONE', min=-1.5700000524520874, max=1.5700000524520874, step=3, precision=2, update=sna_update_sna_cr_counter_steering_A8CCC)
    bpy.types.Object.sna_cr_drift = bpy.props.FloatProperty(name='cr_drift', description='', default=0.0, subtype='NONE', unit='NONE', min=-10.0, max=10.0, step=3, precision=3, update=sna_update_sna_cr_drift_025AD)
    bpy.types.Object.sna_cr_jump_fr = bpy.props.FloatProperty(name='cr_jump_fr', description='', default=0.0, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=2, update=sna_update_sna_cr_jump_fr_34090)
    bpy.types.Object.sna_cr_jump_bk = bpy.props.FloatProperty(name='cr_jump_bk', description='', default=0.0, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=2, update=sna_update_sna_cr_jump_bk_37550)
    bpy.types.Object.sna_cr_wheel_scale = bpy.props.FloatProperty(name='cr_wheel_scale', description='', default=1.0, subtype='NONE', unit='NONE', min=0.009999999776482582, max=10.0, step=3, precision=3, update=sna_update_sna_cr_wheel_scale_3F964)
    bpy.types.Object.sna_cr_drift_dist = bpy.props.FloatProperty(name='cr_drift_dist', description='', default=1.0, subtype='NONE', unit='NONE', step=3, precision=6)
    bpy.types.Object.sna_cr_drift_bank_factor = bpy.props.FloatProperty(name='cr_drift_bank_factor', description='', default=0.20000000298023224, subtype='NONE', unit='NONE', step=3, precision=3)
    bpy.types.Object.sna_cr_brake_fr = bpy.props.FloatProperty(name='cr_brake_fr', description='', default=0.0, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=2)
    bpy.types.Object.sna_cr_brake_bk = bpy.props.FloatProperty(name='cr_brake_bk', description='', default=0.0, subtype='NONE', unit='NONE', min=0.0, max=1.0, step=3, precision=2)
    bpy.types.Scene.sna_cr_rigicar_objects_col = bpy.props.CollectionProperty(name='cr_rigicar_objects_col', description='', type=SNA_GROUP_sna_cr_rigicar_objects_col_group)
    bpy.types.Scene.sna_cr_rigicar_objects_col_index = bpy.props.IntProperty(name='cr_rigicar_objects_col_index', description='', default=0, subtype='NONE')
    if not 'pictofilmo_icon_128.png' in _icons: _icons.load('pictofilmo_icon_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'pictofilmo_icon_128.png'), "IMAGE")
    if not 'Blender+Market_ico_128.png' in _icons: _icons.load('Blender+Market_ico_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'Blender+Market_ico_128.png'), "IMAGE")
    if not 'gumraod_icon_128.png' in _icons: _icons.load('gumraod_icon_128.png', os.path.join(os.path.dirname(__file__), 'icons', 'gumraod_icon_128.png'), "IMAGE")
    bpy.utils.register_class(SNA_OT_Kb_Op_Web_Link_8F33D)
    bpy.utils.register_class(SNA_OT_Cr_Op_Fiil_Spring_List_Afd4A)
    bpy.utils.register_class(SNA_OT_Cr_Op_Clone_Rigicar_42D39)
    bpy.utils.register_class(SNA_OT_Cr_Op_Bake_2_Meshes_8F15D)
    bpy.utils.register_class(SNA_OT_Cr_Op_Setup_Wheels_24503)
    bpy.utils.register_class(SNA_OT_Cr_Op_Turn_Car_Direction_97B1F)
    bpy.app.handlers.render_init.append(render_init_handler_B0A44)
    bpy.utils.register_class(SNA_PT_RIGICAR_13EF3)
    bpy.app.handlers.frame_change_post.append(frame_change_post_handler_B0813)
    bpy.app.handlers.render_cancel.append(render_cancel_handler_03D6E)
    bpy.app.handlers.render_complete.append(render_complete_handler_13363)
    bpy.utils.register_class(SNA_OT_Cr_Mop_Algin_Wheels_F10C6)
    bpy.utils.register_class(SNA_OT_Cr_Mop_Algin_Car_C9Dcf)
    bpy.utils.register_class(SNA_OT_Cr_Op_Toggle_90495)
    bpy.app.handlers.render_init.append(render_init_handler_D36F0)
    bpy.utils.register_class(SNA_OT_Cr_Op_Paste_Parametters_52B4D)
    bpy.utils.register_class(SNA_OT_Cr_Op_Copy_Parametters_18D32)
    bpy.utils.register_class(SNA_OT_Cr_Op_Update_Rigicar_Model_94895)
    bpy.utils.register_class(SNA_PT_setup_9AF9E)
    if not 'car_caisse_icon.png' in _icons: _icons.load('car_caisse_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_caisse_icon.png'), "IMAGE")
    if not 'car_flat_wheel_icon.png' in _icons: _icons.load('car_flat_wheel_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_flat_wheel_icon.png'), "IMAGE")
    if not 'car_long_icon.png' in _icons: _icons.load('car_long_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_long_icon.png'), "IMAGE")
    if not 'car_large_icon.png' in _icons: _icons.load('car_large_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_large_icon.png'), "IMAGE")
    if not 'car_scale_wheel_icon.png' in _icons: _icons.load('car_scale_wheel_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_scale_wheel_icon.png'), "IMAGE")
    if not 'anchor_icon.png' in _icons: _icons.load('anchor_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'anchor_icon.png'), "IMAGE")
    if not 'car_soft_ground_icon.png' in _icons: _icons.load('car_soft_ground_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_soft_ground_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_animation_BA400)
    if not 'car_speed_icon.png' in _icons: _icons.load('car_speed_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_speed_icon.png'), "IMAGE")
    if not 'car_bank_icon.png' in _icons: _icons.load('car_bank_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_bank_icon.png'), "IMAGE")
    if not 'car_acc_icon.png' in _icons: _icons.load('car_acc_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_acc_icon.png'), "IMAGE")
    if not 'car_drift_icon.png' in _icons: _icons.load('car_drift_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_drift_icon.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_dampers_6766F)
    if not 'car_spring_ico.png' in _icons: _icons.load('car_spring_ico.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_spring_ico.png'), "IMAGE")
    bpy.utils.register_class(SNA_PT_bake_3A112)
    bpy.utils.register_class(SNA_PT_about_5C7F0)
    bpy.utils.register_class(SNA_PT_advanced_animation_0FE09)
    if not 'car_drift_icon.png' in _icons: _icons.load('car_drift_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_drift_icon.png'), "IMAGE")
    if not 'car_torque_icon.png' in _icons: _icons.load('car_torque_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_torque_icon.png'), "IMAGE")
    if not 'car_counter_steering_icon.png' in _icons: _icons.load('car_counter_steering_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_counter_steering_icon.png'), "IMAGE")
    if not 'car_jump_icon.png' in _icons: _icons.load('car_jump_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'car_jump_icon.png'), "IMAGE")
    if not 'brake_icon.png' in _icons: _icons.load('brake_icon.png', os.path.join(os.path.dirname(__file__), 'icons', 'brake_icon.png'), "IMAGE")


def unregister():
    global _icons
    bpy.utils.previews.remove(_icons)
    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon
    for km, kmi in addon_keymaps.values():
        km.keymap_items.remove(kmi)
    addon_keymaps.clear()
    del bpy.types.Scene.sna_cr_rigicar_objects_col_index
    del bpy.types.Scene.sna_cr_rigicar_objects_col
    del bpy.types.Object.sna_cr_brake_bk
    del bpy.types.Object.sna_cr_brake_fr
    del bpy.types.Object.sna_cr_drift_bank_factor
    del bpy.types.Object.sna_cr_drift_dist
    del bpy.types.Object.sna_cr_wheel_scale
    del bpy.types.Object.sna_cr_jump_bk
    del bpy.types.Object.sna_cr_jump_fr
    del bpy.types.Object.sna_cr_drift
    del bpy.types.Object.sna_cr_counter_steering
    del bpy.types.Object.sna_cr_transmission_mode
    del bpy.types.Object.sna_cr_torque
    del bpy.types.Object.sna_cr_view_rig
    del bpy.types.Object.sna_cr_path_curve_len
    del bpy.types.Object.sna_debug_state
    del bpy.types.Object.sna_cr_spring_list_index
    del bpy.types.Object.sna_cr_sb_spring_bones_col
    del bpy.types.Object.sna_cr_sb_lock_z_axis
    del bpy.types.Object.sna_cr_sb_spring_global_influence
    del bpy.types.Object.sna_cr_sb_spring_damp
    del bpy.types.Object.sna_cr_sb_spring_stiffness
    del bpy.types.Object.sna_cr_sb_global_spring
    del bpy.types.Object.sna_cr_interpol_duration_factor
    del bpy.types.Object.sna_cr_interpol_duration
    del bpy.types.Object.sna_cr_frame_interpol
    del bpy.types.Object.sna_cr_ground_obj
    del bpy.types.Scene.sna_cr_modal_activ
    del bpy.types.Scene.sna_debug
    del bpy.types.Object.sna_cr_instant_speed
    del bpy.types.Object.sna_cr_path_distance
    del bpy.types.Object.sna_cr_wheel_radius
    del bpy.types.Object.sna_cr_chassis_long
    del bpy.types.Object.sna_cr_chassis_large
    del bpy.types.Object.sna_cr_offset_factor
    del bpy.types.Object.sna_cr_id_collec
    del bpy.types.Object.sna_cr_carrig_curve
    del bpy.types.Object.sna_cr_wheel_avg
    del bpy.types.Object.sna_cr_bool
    bpy.utils.unregister_class(SNA_GROUP_sna_cr_rigicar_objects_col_group)
    bpy.utils.unregister_class(SNA_GROUP_sna_cr_sb_spring_group)
    bpy.utils.unregister_class(SNA_GROUP_sna_cr_id_group)
    bpy.utils.unregister_class(SNA_OT_Kb_Op_Web_Link_8F33D)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Fiil_Spring_List_Afd4A)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Clone_Rigicar_42D39)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Bake_2_Meshes_8F15D)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Setup_Wheels_24503)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Turn_Car_Direction_97B1F)
    bpy.app.handlers.render_init.remove(render_init_handler_B0A44)
    bpy.utils.unregister_class(SNA_PT_RIGICAR_13EF3)
    bpy.app.handlers.frame_change_post.remove(frame_change_post_handler_B0813)
    bpy.app.handlers.render_cancel.remove(render_cancel_handler_03D6E)
    bpy.app.handlers.render_complete.remove(render_complete_handler_13363)
    bpy.utils.unregister_class(SNA_OT_Cr_Mop_Algin_Wheels_F10C6)
    bpy.utils.unregister_class(SNA_OT_Cr_Mop_Algin_Car_C9Dcf)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Toggle_90495)
    bpy.app.handlers.render_init.remove(render_init_handler_D36F0)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Paste_Parametters_52B4D)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Copy_Parametters_18D32)
    bpy.utils.unregister_class(SNA_OT_Cr_Op_Update_Rigicar_Model_94895)
    bpy.utils.unregister_class(SNA_PT_setup_9AF9E)
    bpy.utils.unregister_class(SNA_PT_animation_BA400)
    bpy.utils.unregister_class(SNA_PT_dampers_6766F)
    bpy.utils.unregister_class(SNA_PT_bake_3A112)
    bpy.utils.unregister_class(SNA_PT_about_5C7F0)
    bpy.utils.unregister_class(SNA_PT_advanced_animation_0FE09)
